/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingScheme;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

public class OutputCleaningCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final Compiler<T> compiler;
    private final String outputFileSuffix;

    public OutputCleaningCompiler(Compiler<T> compiler, String outputFileSuffix) {
        this.compiler = compiler;
        this.outputFileSuffix = outputFileSuffix;
    }

    public WorkResult execute(T spec) {
        boolean didRemove = this.deleteOutputsForRemovedSources((NativeCompileSpec)spec);
        boolean didCompile = this.compileSources(spec);
        return new SimpleWorkResult(didRemove || didCompile);
    }

    private boolean compileSources(T spec) {
        if (spec.getSourceFiles().isEmpty()) {
            return false;
        }
        return this.compiler.execute(spec).getDidWork();
    }

    private boolean deleteOutputsForRemovedSources(NativeCompileSpec spec) {
        boolean didRemove = false;
        for (File removedSource : spec.getRemovedSourceFiles()) {
            File objectFile = this.getObjectFile(spec.getObjectFileDir(), removedSource);
            if (!objectFile.delete()) continue;
            didRemove = true;
            objectFile.getParentFile().delete();
        }
        return didRemove;
    }

    private File getObjectFile(File objectFileRoot, File sourceFile) {
        return new CompilerOutputFileNamingScheme().withObjectFileNameSuffix(this.outputFileSuffix).withOutputBaseFolder(objectFileRoot).map(sourceFile);
    }
}

