/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.PageRenderer;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.html.SimpleHtmlWriter;

class PackagePageRenderer
extends PageRenderer<PackageTestResults> {
    PackagePageRenderer() {
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("div").attribute("class", "breadcrumbs");
        htmlWriter.startElement("a").attribute("href", ((PackageTestResults)this.getResults()).getUrlTo(((PackageTestResults)this.getResults()).getParent())).characters((CharSequence)"all").endElement();
        htmlWriter.characters((CharSequence)(" > " + ((PackageTestResults)this.getResults()).getName()));
        htmlWriter.endElement();
    }

    private void renderClasses(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thread");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters((CharSequence)"Class").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Tests").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Failures").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Ignored").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Duration").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        for (ClassTestResults testClass : ((PackageTestResults)this.getResults()).getClasses()) {
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td").attribute("class", testClass.getStatusClass());
            htmlWriter.startElement("a").attribute("href", this.asHtmlLinkEncoded(((PackageTestResults)this.getResults()).getUrlTo(testClass))).characters((CharSequence)testClass.getSimpleName()).endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testClass.getTestCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testClass.getFailureCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testClass.getIgnoredCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)testClass.getFormattedDuration()).endElement();
            htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).characters((CharSequence)testClass.getFormattedSuccessRate()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addIgnoredTab();
        this.addTab("Classes", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            public void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                PackagePageRenderer.this.renderClasses(htmlWriter);
            }
        });
    }
}

