/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.compile.CompileSpecToArguments;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.internal.process.ArgCollector;
import org.gradle.internal.process.ArgWriter;

public class CommandLineJavaCompilerArgumentsGenerator
implements CompileSpecToArguments<JavaCompileSpec>,
Serializable {
    public void collectArguments(JavaCompileSpec spec, ArgCollector collector) {
        for (String arg : this.generate(spec)) {
            collector.args(new Object[]{arg});
        }
    }

    public Iterable<String> generate(JavaCompileSpec spec) {
        List<String> remainingArgs;
        List<String> launcherOptions = new JavaCompilerArgumentsBuilder(spec).includeLauncherOptions(true).includeMainOptions(false).includeClasspath(false).includeCustomizations(false).build();
        Iterable allArgs = Iterables.concat(launcherOptions, remainingArgs = new JavaCompilerArgumentsBuilder(spec).includeSourceFiles(true).build());
        if (this.exceedsWindowsCommandLineLengthLimit(allArgs)) {
            return Iterables.concat(launcherOptions, this.shortenArgs(spec.getTempDir(), remainingArgs));
        }
        return allArgs;
    }

    private boolean exceedsWindowsCommandLineLengthLimit(Iterable<String> args) {
        int length = 0;
        for (String arg : args) {
            if ((length += arg.length() + 1) <= 1500) continue;
            return true;
        }
        return false;
    }

    private Iterable<String> shortenArgs(File tempDir, List<String> args) {
        return (Iterable)ArgWriter.argsFileGenerator((File)new File(tempDir, "java-compiler-args.txt"), (Transformer)ArgWriter.unixStyleFactory()).transform(args);
    }
}

