/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecuter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesSetupBuildActionExecuter
implements BuildExecuter {
    private final BuildActionExecuter<BuildActionParameters> delegate;
    private final GradleUserHomeScopeServiceRegistry userHomeServiceRegistry;

    public ServicesSetupBuildActionExecuter(BuildActionExecuter<BuildActionParameters> delegate, GradleUserHomeScopeServiceRegistry userHomeServiceRegistry) {
        this.delegate = delegate;
        this.userHomeServiceRegistry = userHomeServiceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        ServiceRegistry userHomeServices = this.userHomeServiceRegistry.getServicesFor(action.getStartParameter().getGradleUserHomeDir());
        try {
            Object object;
            BuildSessionScopeServices buildSessionScopeServices = new BuildSessionScopeServices(userHomeServices, action.getStartParameter(), actionParameters.getInjectedPluginClasspath());
            try {
                object = this.delegate.execute(action, requestContext, actionParameters, buildSessionScopeServices);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable(buildSessionScopeServices).stop();
                throw throwable;
            }
            CompositeStoppable.stoppable(buildSessionScopeServices).stop();
            return object;
        }
        finally {
            this.userHomeServiceRegistry.release(userHomeServices);
        }
    }
}

