/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.util.AwsHostNameUtils;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3ExecutionContext
extends ExecutionContext {
    private static final Log log = LogFactory.getLog(AmazonS3Client.class);
    private Signer signer;

    public S3ExecutionContext(List<RequestHandler2> requestHandler2s, boolean isMetricEnabled, AmazonWebServiceClient awsClient) {
        super(requestHandler2s, isMetricEnabled, awsClient);
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }

    public Signer getSignerByURI(URI uri) {
        AmazonWebServiceClient awsClient = this.getAwsClient();
        if (awsClient != null && awsClient.getSignerRegionOverride() != null) {
            return this.signer;
        }
        if (ServiceUtils.isS3AccelerateEndpoint(uri.getHost())) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(AwsHostNameUtils.parseRegionName((String)uri.getHost(), (String)"s3"));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region"), (Throwable)e);
            }
        }
        return this.signer;
    }
}

