/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageFeatureSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.jvm.checkers.AdditionalBuiltInsMembersCheckerKt;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/AdditionalBuiltInsMemberOverrideDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageFeatureSettings", "Lorg/jetbrains/kotlin/config/LanguageFeatureSettings;", "kotlin-compiler"})
public final class AdditionalBuiltInsMemberOverrideDeclarationChecker
implements DeclarationChecker {
    public static final AdditionalBuiltInsMemberOverrideDeclarationChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageFeatureSettings languageFeatureSettings) {
        PsiElement overrideKeyword;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageFeatureSettings, "languageFeatureSettings");
        if (languageFeatureSettings.supportsFeature(LanguageFeature.AdditionalBuiltInsMembers)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
            declarationDescriptor = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor resultingDescriptor = callableMemberDescriptor;
        PsiElement psiElement = declaration.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.OVERRIDE_KEYWORD)) == null) {
            return;
        }
        PsiElement psiElement2 = overrideKeyword = psiElement;
        Intrinsics.checkExpressionValueIsNotNull(psiElement2, "overrideKeyword");
        AdditionalBuiltInsMembersCheckerKt.access$reportErrorIfAdditionalBuiltinDescriptor(resultingDescriptor, diagnosticHolder, psiElement2);
    }

    private AdditionalBuiltInsMemberOverrideDeclarationChecker() {
        INSTANCE = this;
    }

    static {
        new AdditionalBuiltInsMemberOverrideDeclarationChecker();
    }
}

