/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.SpecificityComparisonCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"isSignatureNotLessSpecific", "", "T", "specific", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "general", "callbacks", "Lorg/jetbrains/kotlin/resolve/calls/results/SpecificityComparisonCallbacks;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "callHandle", "Lorg/jetbrains/kotlin/resolve/calls/inference/CallHandle;", "kotlin-compiler"})
public final class FlatSignatureSpecificityKt {
    public static final <T> boolean isSignatureNotLessSpecific(@NotNull FlatSignature<? extends T> specific, @NotNull FlatSignature<? extends T> general, @NotNull SpecificityComparisonCallbacks callbacks, @NotNull TypeSpecificityComparator specificityComparator, @NotNull CallHandle callHandle) {
        Intrinsics.checkParameterIsNotNull(specific, "specific");
        Intrinsics.checkParameterIsNotNull(general, "general");
        Intrinsics.checkParameterIsNotNull(callbacks, "callbacks");
        Intrinsics.checkParameterIsNotNull(specificityComparator, "specificityComparator");
        Intrinsics.checkParameterIsNotNull(callHandle, "callHandle");
        if (specific.getHasExtensionReceiver() != general.getHasExtensionReceiver()) {
            return false;
        }
        if (specific.getValueParameterTypes().size() != general.getValueParameterTypes().size()) {
            return false;
        }
        Collection<TypeParameterDescriptor> typeParameters = general.getTypeParameters();
        ConstraintSystem.Builder constraintSystemBuilder = ConstraintSystemBuilderImpl.Companion.forSpecificity();
        TypeSubstitutor typeSubstitutor2 = ConstraintSystem.Builder.DefaultImpls.registerTypeVariables$default(constraintSystemBuilder, callHandle, typeParameters, false, 4, null);
        int numConstraints = 0;
        for (Pair pair : CollectionsKt.zip((Iterable)specific.getValueParameterTypes(), (Iterable)general.getValueParameterTypes())) {
            KotlinType specificType = (KotlinType)pair.component1();
            KotlinType generalType = (KotlinType)pair.component2();
            if (specificType == null || generalType == null) continue;
            if (specificityComparator.isDefinitelyLessSpecific(specificType, generalType)) {
                return false;
            }
            if (typeParameters.isEmpty() || !TypeUtils.dependsOnTypeParameters(generalType, typeParameters)) {
                if (KotlinTypeChecker.DEFAULT.isSubtypeOf(specificType, generalType) || callbacks.isNonSubtypeNotLessSpecific(specificType, generalType)) continue;
                return false;
            }
            KotlinType substitutedGeneralType = typeSubstitutor2.safeSubstitute(generalType, Variance.INVARIANT);
            constraintSystemBuilder.addSubtypeConstraint(specificType, substitutedGeneralType, ConstraintPositionKt.valueParameterPosition(numConstraints++));
        }
        constraintSystemBuilder.fixVariables();
        ConstraintSystem constraintSystem = constraintSystemBuilder.build();
        return !constraintSystem.getStatus().hasContradiction();
    }

    public static /* bridge */ /* synthetic */ boolean isSignatureNotLessSpecific$default(FlatSignature flatSignature, FlatSignature flatSignature2, SpecificityComparisonCallbacks specificityComparisonCallbacks, TypeSpecificityComparator typeSpecificityComparator, CallHandle callHandle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isSignatureNotLessSpecific");
        }
        if ((n & 0x10) != 0) {
            callHandle = CallHandle.NONE.INSTANCE;
        }
        return FlatSignatureSpecificityKt.isSignatureNotLessSpecific(flatSignature, flatSignature2, specificityComparisonCallbacks, typeSpecificityComparator, callHandle);
    }
}

