/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "collectReachable", "", "T", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "from", "(Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;Ljava/lang/Object;)Ljava/util/List;", "isEdgeInCycle", "", "edge", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "ExpansiveEdge", "Graph", "GraphBuilder", "kotlin-compiler"})
public final class NonExpansiveInheritanceRestrictionChecker {
    public static final NonExpansiveInheritanceRestrictionChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void check(@NotNull KtClass declaration, @NotNull ClassDescriptor classDescriptor, @NotNull DiagnosticSink diagnosticHolder) {
        Object object;
        DeclarationDescriptor it;
        Collection collection;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean bl;
        Object it2;
        TypeParameterDescriptor element$iv22;
        List problemNodes;
        Iterable $receiver$iv$iv2;
        block10: {
            void destination$iv$iv2;
            Iterable destination$iv$iv3;
            Object element$iv$iv22;
            void $receiver$iv3;
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
            Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
            TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
            if (typeConstructor2.getParameters().isEmpty()) {
                return;
            }
            TypeConstructor typeConstructor3 = typeConstructor2;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
            GraphBuilder builder = new GraphBuilder(typeConstructor3);
            Graph<TypeParameterDescriptor> graph2 = builder.build();
            Iterable iterable = graph2.getExpansiveEdges();
            void var7_7 = $receiver$iv3;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv22 : var7_7) {
                ExpansiveEdge it3 = (ExpansiveEdge)element$iv$iv22;
                if (!INSTANCE.isEdgeInCycle(graph2, it3)) continue;
                destination$iv$iv3.add(element$iv$iv22);
            }
            List edgesInCycles = (List)destination$iv$iv3;
            if (edgesInCycles.isEmpty()) {
                return;
            }
            Iterable iterable2 = edgesInCycles;
            destination$iv$iv3 = iterable2;
            Collection collection3 = new ArrayList();
            element$iv$iv22 = $receiver$iv$iv2.iterator();
            while (element$iv$iv22.hasNext()) {
                Object element$iv$iv3 = element$iv$iv22.next();
                ExpansiveEdge it4 = (ExpansiveEdge)element$iv$iv3;
                Iterable list$iv$iv = SetsKt.setOf(new TypeParameterDescriptor[]{(TypeParameterDescriptor)it4.getFrom(), (TypeParameterDescriptor)it4.getTo()});
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            problemNodes = (List)destination$iv$iv2;
            for (TypeParameterDescriptor typeParameterDescriptor : typeConstructor2.getParameters()) {
                if (!problemNodes.contains(typeParameterDescriptor)) continue;
                DeclarationDescriptor declarationDescriptor = typeParameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "typeParameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (psiElement == null) {
                    psiElement = declaration;
                }
                PsiElement element = psiElement;
                diagnosticHolder.report(Errors.EXPANSIVE_INHERITANCE.on(element));
                return;
            }
            Iterable iterable3 = problemNodes;
            for (TypeParameterDescriptor element$iv22 : iterable3) {
                it2 = element$iv22;
                if (!(Intrinsics.areEqual(it2.getSource(), SourceElement.NO_SOURCE) ^ true)) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        $receiver$iv$iv2 = problemNodes;
        element$iv22 = $receiver$iv;
        it2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor $i$a$1$flatMap = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getContainingDeclaration();
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (DeclarationDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            object = DescriptorUtilsKt.getFqNameUnsafe(it).asString();
            collection.add(object);
        }
        SortedSet sortedSet = CollectionsKt.toSortedSet((List)destination$iv$iv);
        diagnosticHolder.report(Errors.EXPANSIVE_INHERITANCE_IN_JAVA.on(declaration, CollectionsKt.joinToString$default(sortedSet, ", ", null, null, 0, null, null, 62, null)));
    }

    private final <T> boolean isEdgeInCycle(@NotNull Graph<T> $receiver, ExpansiveEdge<? extends T> edge) {
        return this.collectReachable($receiver, edge.getTo()).contains(edge.getFrom());
    }

    private final <T> List<T> collectReachable(@NotNull Graph<T> $receiver, T from) {
        DFS.NodeHandlerWithListResult handler2 = new DFS.NodeHandlerWithListResult<T, T>(){

            public void afterChildren(@Nullable T current) {
                ((LinkedList)this.result).add(current);
            }
        };
        DFS.Neighbors neighbors2 = new DFS.Neighbors<T>($receiver){
            final /* synthetic */ Graph receiver$0;

            @NotNull
            public Iterable<T> getNeighbors(T current) {
                return this.receiver$0.getNeighbors(current);
            }
            {
                this.receiver$0 = $receiver;
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf(from), neighbors2, handler2);
        List list2 = (List)handler2.result();
        Intrinsics.checkExpressionValueIsNotNull(list2, "handler.result()");
        return list2;
    }

    private NonExpansiveInheritanceRestrictionChecker() {
        INSTANCE = this;
    }

    static {
        new NonExpansiveInheritanceRestrictionChecker();
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$GraphBuilder;", "", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)V", "edgeLists", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "", "expansiveEdges", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "processedTypeConstructors", "getTypeConstructor", "()Lorg/jetbrains/kotlin/types/TypeConstructor;", "addEdge", "", "from", "to", "expansive", "", "build", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "doBuildGraph", "kotlin-compiler"})
    private static final class GraphBuilder {
        private final HashSet<TypeConstructor> processedTypeConstructors;
        private final HashSet<ExpansiveEdge<TypeParameterDescriptor>> expansiveEdges;
        private final HashMap<TypeParameterDescriptor, Set<TypeParameterDescriptor>> edgeLists;
        @NotNull
        private final TypeConstructor typeConstructor;

        @NotNull
        public final Graph<TypeParameterDescriptor> build() {
            this.doBuildGraph(this.typeConstructor);
            return new Graph<TypeParameterDescriptor>(this){
                @NotNull
                private final HashSet<ExpansiveEdge<TypeParameterDescriptor>> expansiveEdges;
                final /* synthetic */ GraphBuilder this$0;

                @NotNull
                public Collection<TypeParameterDescriptor> getNeighbors(@NotNull TypeParameterDescriptor node) {
                    Intrinsics.checkParameterIsNotNull(node, "node");
                    Set set = (Set)GraphBuilder.access$getEdgeLists$p(this.this$0).get(node);
                    return set != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
                }

                @NotNull
                public HashSet<ExpansiveEdge<TypeParameterDescriptor>> getExpansiveEdges() {
                    return this.expansiveEdges;
                }
                {
                    this.this$0 = $outer;
                    this.expansiveEdges = GraphBuilder.access$getExpansiveEdges$p($outer);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final void addEdge(TypeParameterDescriptor from, TypeParameterDescriptor to, boolean expansive) {
            Object object;
            void $receiver$iv;
            Map map2 = this.edgeLists;
            Object value$iv = $receiver$iv.get(from);
            if (value$iv == null) {
                LinkedHashSet<TypeParameterDescriptor> answer$iv = SetsKt.linkedSetOf(new TypeParameterDescriptor[0]);
                $receiver$iv.put(from, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(to);
            if (expansive) {
                this.expansiveEdges.add(new ExpansiveEdge<TypeParameterDescriptor>(from, to));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void doBuildGraph(TypeConstructor typeConstructor2) {
            if (typeConstructor2.getParameters().isEmpty()) {
                return;
            }
            List<TypeParameterDescriptor> typeParameters = typeConstructor2.getParameters();
            Collection<KotlinType> collection = typeConstructor2.getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, "typeConstructor.supertypes");
            for (KotlinType constituentType : TypeUtilsKt.constituentTypes(collection)) {
                void $receiver$iv;
                TypeConstructor constituentTypeConstructor = constituentType.getConstructor();
                if (this.processedTypeConstructors.contains(constituentTypeConstructor) ^ true) {
                    this.processedTypeConstructors.add(constituentTypeConstructor);
                    this.doBuildGraph(constituentTypeConstructor);
                }
                if (constituentTypeConstructor.getParameters().size() != constituentType.getArguments().size()) continue;
                Iterable iterable = constituentType.getArguments();
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void destination$iv$iv;
                    void $receiver$iv$iv$iv;
                    void $receiver$iv$iv;
                    void $receiver$iv2;
                    void typeProjection;
                    int n = index$iv++;
                    TypeProjection typeProjection2 = (TypeProjection)item$iv;
                    int i = n;
                    if (Intrinsics.areEqual((Object)typeProjection.getProjectionKind(), (Object)Variance.INVARIANT)) {
                        Collection<KotlinType> constituents = TypeUtilsKt.constituentTypes((Collection<? extends KotlinType>)SetsKt.setOf(typeProjection.getType()));
                        for (TypeParameterDescriptor typeParameter : typeParameters) {
                            if (!constituents.contains(typeParameter.getDefaultType()) && !constituents.contains(typeParameter.getDefaultType().makeNullableAsSpecified(true))) continue;
                            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
                            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                            TypeParameterDescriptor typeParameterDescriptor2 = constituentTypeConstructor.getParameters().get(i);
                            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "constituentTypeConstructor.parameters[i]");
                            this.addEdge(typeParameterDescriptor, typeParameterDescriptor2, !TypeUtils.isTypeParameter(typeProjection.getType()));
                        }
                        continue;
                    }
                    TypeParameterDescriptor originalTypeParameter = constituentTypeConstructor.getParameters().get(i);
                    HashSet<KotlinType> bounds = SetsKt.hashSetOf(new KotlinType[0]);
                    TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.create(constituentType).buildSubstitutor();
                    Iterable iterable2 = originalTypeParameter.getUpperBounds();
                    void var16_16 = $receiver$iv2;
                    Collection collection2 = new ArrayList();
                    Iterator<TypeParameterDescriptor> iterator2 = $receiver$iv$iv;
                    for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                        KotlinType kotlinType;
                        Object element$iv$iv = element$iv$iv$iv;
                        KotlinType it = (KotlinType)element$iv$iv;
                        if (substitutor2.substitute(it, Variance.INVARIANT) == null) continue;
                        KotlinType it$iv$iv = kotlinType;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List adaptedUpperBounds = (List)destination$iv$iv;
                    bounds.addAll(adaptedUpperBounds);
                    if (!typeProjection.isStarProjection()) {
                        bounds.add(typeProjection.getType());
                    }
                    Collection<KotlinType> boundClosure2 = TypeUtilsKt.boundClosure((Collection<? extends KotlinType>)bounds);
                    Collection<KotlinType> constituentTypes = TypeUtilsKt.constituentTypes(boundClosure2);
                    for (TypeParameterDescriptor typeParameter : typeParameters) {
                        if (!constituentTypes.contains(typeParameter.getDefaultType()) && !constituentTypes.contains(typeParameter.getDefaultType().makeNullableAsSpecified(true))) continue;
                        TypeParameterDescriptor typeParameterDescriptor = typeParameter;
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                        TypeParameterDescriptor typeParameterDescriptor3 = originalTypeParameter;
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor3, "originalTypeParameter");
                        this.addEdge(typeParameterDescriptor, typeParameterDescriptor3, true);
                    }
                }
            }
        }

        @NotNull
        public final TypeConstructor getTypeConstructor() {
            return this.typeConstructor;
        }

        public GraphBuilder(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
            this.typeConstructor = typeConstructor2;
            this.processedTypeConstructors = SetsKt.hashSetOf(new TypeConstructor[0]);
            this.expansiveEdges = SetsKt.hashSetOf(new ExpansiveEdge[0]);
            this.edgeLists = MapsKt.hashMapOf(new Pair[0]);
        }

        @NotNull
        public static final /* synthetic */ HashMap access$getEdgeLists$p(GraphBuilder $this) {
            return $this.edgeLists;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getExpansiveEdges$p(GraphBuilder $this) {
            return $this.expansiveEdges;
        }
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\b\u0082\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J(\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\rR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "T", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTo", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "kotlin-compiler"})
    private static final class ExpansiveEdge<T> {
        private final T from;
        private final T to;

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public ExpansiveEdge(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public final T component1() {
            return this.from;
        }

        public final T component2() {
            return this.to;
        }

        @NotNull
        public final ExpansiveEdge<T> copy(T from, T to) {
            return new ExpansiveEdge<T>(from, to);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ExpansiveEdge copy$default(ExpansiveEdge expansiveEdge, Object object, Object object2, int n, Object object3) {
            if (object3 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                object = expansiveEdge.from;
            }
            if ((n & 2) != 0) {
                object2 = expansiveEdge.to;
            }
            return expansiveEdge.copy(object, object2);
        }

        public String toString() {
            return "ExpansiveEdge(from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            T t = this.from;
            T t2 = this.to;
            return (t != null ? t.hashCode() : 0) * 31 + (t2 != null ? t2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExpansiveEdge)) break block3;
                    ExpansiveEdge expansiveEdge = (ExpansiveEdge)object;
                    if (!Intrinsics.areEqual(this.from, expansiveEdge.from) || !Intrinsics.areEqual(this.to, expansiveEdge.to)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000bR\u001e\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "T", "", "expansiveEdges", "", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "getExpansiveEdges", "()Ljava/util/Set;", "getNeighbors", "", "node", "(Ljava/lang/Object;)Ljava/util/Collection;", "kotlin-compiler"})
    private static interface Graph<T> {
        @NotNull
        public Collection<T> getNeighbors(T var1);

        @NotNull
        public Set<ExpansiveEdge<T>> getExpansiveEdges();
    }
}

