/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiParser;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.parsing.KotlinParsing;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilderImpl;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;

public class KotlinParser
implements PsiParser {
    private final KotlinScriptDefinitionProvider scriptDefinitionProvider;

    public KotlinParser(Project project) {
        this.scriptDefinitionProvider = KotlinScriptDefinitionProvider.getInstance(project);
    }

    @Override
    @NotNull
    public ASTNode parse(IElementType iElementType, PsiBuilder psiBuilder) {
        throw new IllegalStateException("use another parse");
    }

    @NotNull
    public ASTNode parse(IElementType iElementType, PsiBuilder psiBuilder, PsiFile psiFile) {
        KotlinParsing jetParsing = KotlinParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        if (this.scriptDefinitionProvider != null && this.scriptDefinitionProvider.isScript(psiFile) || psiFile.getName().endsWith(".kts")) {
            jetParsing.parseScript();
        } else {
            jetParsing.parseFile();
        }
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParser", "parse"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseTypeCodeFragment(PsiBuilder psiBuilder) {
        KotlinParsing jetParsing = KotlinParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        jetParsing.parseTypeCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParser", "parseTypeCodeFragment"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseExpressionCodeFragment(PsiBuilder psiBuilder) {
        KotlinParsing jetParsing = KotlinParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        jetParsing.parseExpressionCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParser", "parseExpressionCodeFragment"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseBlockCodeFragment(PsiBuilder psiBuilder) {
        KotlinParsing jetParsing = KotlinParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        jetParsing.parseBlockCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParser", "parseBlockCodeFragment"));
        }
        return aSTNode;
    }
}

