/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.kotlin.org.picocontainer.ComponentMonitor;
import org.jetbrains.kotlin.org.picocontainer.Parameter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoInitializationException;
import org.jetbrains.kotlin.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.ThreadLocalCyclicDependencyGuard;
import org.jetbrains.kotlin.org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.jetbrains.kotlin.org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ConstructorInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private transient List sortedMatchingConstructors;
    private transient Guard instantiationGuard;

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters2, allowNonPublicClasses);
    }

    @Override
    protected Constructor getGreediestSatisfiableConstructor(PicoContainer container) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        if (this.sortedMatchingConstructors == null) {
            this.sortedMatchingConstructors = this.getSortedMatchingConstructors();
        }
        Constructor greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class unsatisfiedDependencyType = null;
        for (int i = 0; i < this.sortedMatchingConstructors.size(); ++i) {
            boolean failedDependency = false;
            Constructor constructor = (Constructor)this.sortedMatchingConstructors.get(i);
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container, this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = parameterTypes[j];
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container);
        }
        if (greediestConstructor == null) {
            HashSet<Constructor> nonMatching = new HashSet<Constructor>();
            Constructor[] constructors2 = this.getConstructors();
            for (int i = 0; i < constructors2.length; ++i) {
                nonMatching.add(constructors2[i]);
            }
            throw new PicoInitializationException(new StringBuffer().append("Either do the specified parameters not match any of the following constructors: ").append(((Object)nonMatching).toString()).append(" or the constructors were not accessible for '").append(this.getComponentImplementation()).append("'").toString());
        }
        return greediestConstructor;
    }

    @Override
    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new Guard(){

                @Override
                public Object run() {
                    Constructor constructor;
                    try {
                        constructor = ConstructorInjectionComponentAdapter.this.getGreediestSatisfiableConstructor(this.guardedContainer);
                    }
                    catch (AmbiguousComponentResolutionException e) {
                        e.setComponent(ConstructorInjectionComponentAdapter.this.getComponentImplementation());
                        throw e;
                    }
                    ComponentMonitor componentMonitor = ConstructorInjectionComponentAdapter.this.currentMonitor();
                    try {
                        Object[] parameters2 = ConstructorInjectionComponentAdapter.this.getConstructorArguments(this.guardedContainer, constructor);
                        componentMonitor.instantiating(constructor);
                        long startTime = System.currentTimeMillis();
                        Object inst = ConstructorInjectionComponentAdapter.this.newInstance(constructor, parameters2);
                        componentMonitor.instantiated(constructor, System.currentTimeMillis() - startTime);
                        return inst;
                    }
                    catch (InvocationTargetException e) {
                        componentMonitor.instantiationFailed(constructor, e);
                        if (e.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        if (e.getTargetException() instanceof Error) {
                            throw (Error)e.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(e.getTargetException());
                    }
                    catch (InstantiationException e) {
                        componentMonitor.instantiationFailed(constructor, e);
                        throw new PicoInitializationException("Should never get here");
                    }
                    catch (IllegalAccessException e) {
                        componentMonitor.instantiationFailed(constructor, e);
                        throw new PicoInitializationException(e);
                    }
                }
            };
        }
        this.instantiationGuard.setArguments(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    protected Object[] getConstructorArguments(PicoContainer container, Constructor ctor) {
        Class[] parameterTypes = ctor.getParameterTypes();
        Object[] result2 = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            result2[i] = currentParameters[i].resolveInstance(container, this, parameterTypes[i]);
        }
        return result2;
    }

    private List getSortedMatchingConstructors() {
        ArrayList<Constructor> matchingConstructors = new ArrayList<Constructor>();
        Constructor[] allConstructors = this.getConstructors();
        for (int i = 0; i < allConstructors.length; ++i) {
            Constructor constructor = allConstructors[i];
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            Collections.sort(matchingConstructors, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((Constructor)arg1).getParameterTypes().length - ((Constructor)arg0).getParameterTypes().length;
                }
            });
        }
        return matchingConstructors;
    }

    private Constructor[] getConstructors() {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ConstructorInjectionComponentAdapter.this.getComponentImplementation().getDeclaredConstructors();
            }
        });
    }

    private static abstract class Guard
    extends ThreadLocalCyclicDependencyGuard {
        protected PicoContainer guardedContainer;

        private Guard() {
        }

        private void setArguments(PicoContainer container) {
            this.guardedContainer = container;
        }
    }
}

