/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.AccessToken;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.PairProcessor;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import sun.misc.Unsafe;

public class DebugReflectionUtil {
    private static final Map<Class, Field[]> allFields = new THashMap<Class, Field[]>();
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Method Unsafe_shouldBeInitialized = ReflectionUtil.getDeclaredMethod(Unsafe.class, "shouldBeInitialized", Class.class);

    @NotNull
    private static Field[] getAllFields(@NotNull Class aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/DebugReflectionUtil", "getAllFields"));
        }
        Field[] cached = allFields.get(aClass2);
        if (cached == null) {
            try {
                Field[] declaredFields = aClass2.getDeclaredFields();
                ArrayList<Field> fields2 = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField : declaredFields) {
                    declaredField.setAccessible(true);
                    Class<?> type2 = declaredField.getType();
                    if (DebugReflectionUtil.isTrivial(type2)) continue;
                    fields2.add(declaredField);
                }
                Class superclass = aClass2.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields2.contains(sup)) continue;
                        fields2.add(sup);
                    }
                }
                cached = fields2.isEmpty() ? EMPTY_FIELD_ARRAY : fields2.toArray(new Field[fields2.size()]);
            }
            catch (IncompatibleClassChangeError e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (SecurityException e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (NoClassDefFoundError e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            allFields.put(aClass2, cached);
        }
        if (cached == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/DebugReflectionUtil", "getAllFields"));
        }
        return cached;
    }

    private static boolean isTrivial(@NotNull Class<?> type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/util/DebugReflectionUtil", "isTrivial"));
        }
        return type2.isPrimitive() || type2 == String.class || type2 == Class.class || type2.isArray() && DebugReflectionUtil.isTrivial(type2.getComponentType());
    }

    public static boolean processStronglyReferencedValues(@NotNull Object root, PairProcessor<Object, Field> processor) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/util/DebugReflectionUtil", "processStronglyReferencedValues"));
        }
        Class<?> rootClass = root.getClass();
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            Object value;
            String fieldName = field.getName();
            if (root instanceof Reference && "referent".equals(fieldName)) continue;
            try {
                value = field.get(root);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (value == null || processor.process(value, field)) continue;
            return false;
        }
        if (rootClass.isArray()) {
            try {
                for (Object object : (Object[])root) {
                    if (object == null || DebugReflectionUtil.isTrivial(object.getClass()) || processor.process(object, null)) continue;
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root instanceof Class && DebugReflectionUtil.isLoadedAlready((Class)root)) {
            try {
                for (Field field : DebugReflectionUtil.getAllFields((Class)root)) {
                    Object value;
                    if ((field.getModifiers() & 8) == 0 || (value = field.get(null)) == null || processor.process(value, field)) continue;
                    return false;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return true;
    }

    private static boolean isLoadedAlready(@NotNull Class root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/util/DebugReflectionUtil", "isLoadedAlready"));
        }
        if (Unsafe_shouldBeInitialized == null) {
            return false;
        }
        boolean isLoadedAlready = false;
        try {
            isLoadedAlready = (Boolean)Unsafe_shouldBeInitialized.invoke((Object)AtomicFieldUpdater.getUnsafe(), root) == false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isLoadedAlready;
    }

    public static class BackLink {
        @NotNull
        public final Object value;
        private final Field field;
        private final BackLink backLink;

        public BackLink(@NotNull Object value, @Nullable Field field, @Nullable BackLink backLink) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/DebugReflectionUtil$BackLink", "<init>"));
            }
            this.value = value;
            this.field = field;
            this.backLink = backLink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            BackLink backLink = this;
            String result2 = "";
            while (backLink != null) {
                String valueStr;
                AccessToken token = ReadAction.start();
                try {
                    valueStr = backLink.value instanceof FList ? "FList (size=" + ((FList)backLink.value).size() + ")" : (backLink.value instanceof Collection ? "Collection (size=" + ((Collection)backLink.value).size() + ")" : String.valueOf(backLink.value));
                    valueStr = StringUtil.first(StringUtil.convertLineSeparators(valueStr, "\\n"), 200, true);
                }
                catch (Throwable e) {
                    valueStr = "(" + e.getMessage() + " while computing .toString())";
                }
                finally {
                    token.finish();
                }
                Field field = backLink.field;
                String fieldName = field == null ? "?" : field.getDeclaringClass().getName() + "." + field.getName();
                result2 = result2 + "via '" + fieldName + "'; Value: '" + valueStr + "' of " + backLink.value.getClass() + "\n";
                backLink = backLink.backLink;
            }
            return result2;
        }
    }
}

