/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.reflect.Field;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.DebugReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.PairProcessor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.gnu.trove.THashSet;

class CachedValueChecker {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.CachedValueChecker");
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static final Set<String> ourCheckedKeys = ContainerUtil.newConcurrentSet();

    static void checkProvider(@NotNull CachedValueProvider provider, @NotNull Key key, @NotNull UserDataHolder userDataHolder) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/util/CachedValueChecker", "checkProvider"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/util/CachedValueChecker", "checkProvider"));
        }
        if (userDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userDataHolder", "org/jetbrains/kotlin/com/intellij/util/CachedValueChecker", "checkProvider"));
        }
        if (!DO_CHECKS) {
            return;
        }
        if (!ourCheckedKeys.add(key.toString())) {
            return;
        }
        THashSet<Object> visited2 = ContainerUtil.newIdentityTroveSet();
        DebugReflectionUtil.BackLink path = CachedValueChecker.findReferencedPsi(provider, userDataHolder, 6, visited2, null);
        if (path != null) {
            LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access, provider=" + provider + "\n" + path);
        }
    }

    @Nullable
    private static synchronized DebugReflectionUtil.BackLink findReferencedPsi(@NotNull Object o, final @Nullable UserDataHolder toIgnore, final int depth, final @NotNull Set<Object> visited2, final @Nullable DebugReflectionUtil.BackLink backLink) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/util/CachedValueChecker", "findReferencedPsi"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/kotlin/com/intellij/util/CachedValueChecker", "findReferencedPsi"));
        }
        if (depth == 0 || o == toIgnore || !visited2.add(o)) {
            return null;
        }
        if (o instanceof Project || o instanceof Module || o instanceof Application) {
            return null;
        }
        if (o instanceof PsiElement) {
            if (toIgnore instanceof PsiElement && ((PsiElement)toIgnore).getContainingFile() != null && PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)toIgnore, true)) {
                return null;
            }
            return backLink;
        }
        final Ref result2 = Ref.create();
        DebugReflectionUtil.processStronglyReferencedValues(o, new PairProcessor<Object, Field>(){

            @Override
            public boolean process(Object next, Field field) {
                result2.set(CachedValueChecker.findReferencedPsi(next, toIgnore, depth - 1, visited2, new DebugReflectionUtil.BackLink(next, field, backLink)));
                return result2.isNull();
            }
        });
        return (DebugReflectionUtil.BackLink)result2.get();
    }
}

