/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.ui.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class LightMethod
extends LightElement
implements PsiMethod {
    private final PsiMethod myMethod;
    private final PsiClass myContainingClass;

    public LightMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        this(manager, method, containingClass, JavaLanguage.INSTANCE);
    }

    public LightMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        super(manager, language);
        this.myMethod = method;
        this.myContainingClass = containingClass;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public boolean hasTypeParameters() {
        return this.myMethod.hasTypeParameters();
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = this.myMethod.getTypeParameters();
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return this.myMethod.getTypeParameterList();
    }

    @Override
    public PsiDocComment getDocComment() {
        return this.myMethod.getDocComment();
    }

    @Override
    public boolean isDeprecated() {
        return this.myMethod.isDeprecated();
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "setName"));
        }
        return this.myMethod.setName(name);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = this.myMethod.getHierarchicalMethodSignature();
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "hasModifierProperty"));
        }
        return this.myMethod.hasModifierProperty(name);
    }

    @Override
    public TextRange getTextRange() {
        return this.myMethod.getTextRange();
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.myMethod.getModifierList();
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    public PsiType getReturnType() {
        return this.myMethod.getReturnType();
    }

    @Override
    public PsiTypeElement getReturnTypeElement() {
        return this.myMethod.getReturnTypeElement();
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = this.myMethod.getParameterList();
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getParameterList"));
        }
        return psiParameterList;
    }

    @Override
    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.myMethod.getThrowsList();
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getThrowsList"));
        }
        return psiReferenceList;
    }

    @Override
    public PsiCodeBlock getBody() {
        return this.myMethod.getBody();
    }

    @Override
    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    @Override
    public boolean isVarArgs() {
        return this.myMethod.isVarArgs();
    }

    @Override
    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getSignature"));
        }
        MethodSignature methodSignature = this.myMethod.getSignature(substitutor2);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getSignature"));
        }
        return methodSignature;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return this.myMethod.getNameIdentifier();
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods(checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods(parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list2 = this.myMethod.findSuperMethodSignaturesIncludingStatic(checkAccess);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list2;
    }

    @Override
    public PsiMethod findDeepestSuperMethod() {
        return this.myMethod.findDeepestSuperMethod();
    }

    @Override
    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = this.myMethod.findDeepestSuperMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    public String getText() {
        return this.myMethod.getText();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "accept"));
        }
        this.myMethod.accept(visitor2);
    }

    @Override
    public PsiElement copy() {
        return new LightMethod(this.myManager, (PsiMethod)this.myMethod.copy(), this.myContainingClass);
    }

    @Override
    public boolean isValid() {
        return this.myContainingClass.isValid();
    }

    @Override
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myContainingClass.getContainingFile();
    }

    @Override
    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethod", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    public PsiElement getContext() {
        return this.getContainingClass();
    }
}

