/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JavaFileType;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.DeclarationParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;

public class PsiJavaParserFacadeImpl
implements PsiJavaParserFacade {
    protected final PsiManager myManager;
    private static final String DUMMY_FILE_NAME = "_Dummy_." + JavaFileType.INSTANCE.getDefaultExtension();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper PARAMETER = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseParameter(builder, true, false);
        }
    };
    private static final JavaParserUtil.ParserWrapper RESOURCE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseResource(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper TYPE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseType(builder, 23);
        }
    };
    public static final JavaParserUtil.ParserWrapper REFERENCE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
        }
    };
    public static final JavaParserUtil.ParserWrapper DIAMOND_REF = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, true);
        }
    };
    public static final JavaParserUtil.ParserWrapper STATIC_IMPORT_REF = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseImportCodeReference(builder, true);
        }
    };
    private static final JavaParserUtil.ParserWrapper TYPE_PARAMETER = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseTypeParameter(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper DECLARATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parse(builder, DeclarationParser.Context.CLASS);
        }
    };
    private static final JavaParserUtil.ParserWrapper CODE_BLOCK = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseCodeBlockDeep(builder, true);
        }
    };
    private static final JavaParserUtil.ParserWrapper STATEMENT = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseStatement(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper EXPRESSION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getExpressionParser().parse(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper ENUM_CONSTANT = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseEnumConstant(builder);
        }
    };
    private static final Map<String, PsiPrimitiveType> PRIMITIVE_TYPES = new HashMap<String, PsiPrimitiveType>();

    public PsiJavaParserFacadeImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createAnnotationFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, ANNOTATION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation '" + text2 + "'");
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)element;
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createAnnotationFromText"));
        }
        return psiAnnotation;
    }

    @Override
    @NotNull
    public PsiDocTag createDocTagFromText(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocTagFromText"));
        }
        PsiDocTag psiDocTag = this.createDocCommentFromText(StringUtil.join("/**\n", text2, "\n */")).getTags()[0];
        if (psiDocTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocTagFromText"));
        }
        return psiDocTag;
    }

    @Override
    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String docCommentText) throws IncorrectOperationException {
        if (docCommentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docCommentText", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocCommentFromText"));
        }
        PsiDocComment psiDocComment = this.createDocCommentFromText(docCommentText, null);
        if (psiDocComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocCommentFromText"));
        }
        return psiDocComment;
    }

    @Override
    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocCommentFromText"));
        }
        PsiMethod method = this.createMethodFromText(text2.trim() + "void m();", context);
        PsiDocComment comment = method.getDocComment();
        if (comment == null) {
            throw new IncorrectOperationException("Incorrect comment '" + text2 + "'");
        }
        PsiDocComment psiDocComment = comment;
        if (psiDocComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocCommentFromText"));
        }
        return psiDocComment;
    }

    @Override
    @NotNull
    public PsiClass createClassFromText(@NotNull String body, @Nullable PsiElement context) throws IncorrectOperationException {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createClassFromText"));
        }
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("class _Dummy_ {\n", body, "\n}"));
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length != 1) {
            throw new IncorrectOperationException("Incorrect class '" + body + "'");
        }
        PsiClass psiClass = classes2[0];
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createClassFromText"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createFieldFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, DECLARATION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiField)) {
            throw new IncorrectOperationException("Incorrect field '" + text2 + "'");
        }
        PsiField psiField = (PsiField)element;
        if (psiField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createFieldFromText"));
        }
        return psiField;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text2, @Nullable PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createMethodFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, DECLARATION, level), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiMethod)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect method '" + text2 + "'", holder);
        }
        PsiMethod psiMethod = (PsiMethod)element;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createMethodFromText"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public final PsiMethod createMethodFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createMethodFromText"));
        }
        LanguageLevel level = LanguageLevelProjectExtension.getInstance(this.myManager.getProject()).getLanguageLevel();
        PsiMethod psiMethod = this.createMethodFromText(text2, context, level);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createMethodFromText"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createParameterFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, PARAMETER, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiParameter)) {
            throw new IncorrectOperationException("Incorrect parameter '" + text2 + "'");
        }
        PsiParameter psiParameter = (PsiParameter)element;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createParameterFromText"));
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiResourceVariable createResourceFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createResourceFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, RESOURCE, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiResourceVariable)) {
            throw new IncorrectOperationException("Incorrect resource '" + text2 + "'");
        }
        PsiResourceVariable psiResourceVariable = (PsiResourceVariable)element;
        if (psiResourceVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createResourceFromText"));
        }
        return psiResourceVariable;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeFromText"));
        }
        PsiType psiType = this.createTypeInner(text2, context, false);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeFromText"));
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeElement createTypeElementFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeElementFromText"));
        }
        LanguageLevel level = PsiJavaParserFacadeImpl.level(context);
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, TYPE, level), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeElement)) {
            throw new IncorrectOperationException("Incorrect type '" + text2 + "' (" + (Object)((Object)level) + ")");
        }
        PsiTypeElement psiTypeElement = (PsiTypeElement)element;
        if (psiTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeElementFromText"));
        }
        return psiTypeElement;
    }

    protected PsiType createTypeInner(String text2, @Nullable PsiElement context, boolean markAsCopy) throws IncorrectOperationException {
        PsiPrimitiveType primitiveType = PRIMITIVE_TYPES.get(text2);
        if (primitiveType != null) {
            return primitiveType;
        }
        PsiTypeElement element = this.createTypeElementFromText(text2, context);
        if (markAsCopy) {
            GeneratedMarkerVisitor.markGenerated(element);
        }
        return element.getType();
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        boolean mayHaveDiamonds;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createReferenceFromText"));
        }
        boolean isStaticImport = context instanceof PsiImportStaticStatement && !((PsiImportStaticStatement)context).isOnDemand();
        boolean bl = mayHaveDiamonds = context instanceof PsiNewExpression && PsiUtil.getLanguageLevel(context).isAtLeast(LanguageLevel.JDK_1_7);
        JavaParserUtil.ParserWrapper wrapper = isStaticImport ? STATIC_IMPORT_REF : (mayHaveDiamonds ? DIAMOND_REF : REFERENCE);
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, wrapper, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            throw new IncorrectOperationException("Incorrect reference '" + text2 + "'");
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)element;
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createReferenceFromText"));
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createCodeBlockFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, CODE_BLOCK, PsiJavaParserFacadeImpl.level(context), true), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCodeBlock)) {
            throw new IncorrectOperationException("Incorrect code block '" + text2 + "'");
        }
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)element;
        if (psiCodeBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createCodeBlockFromText"));
        }
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createStatementFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, STATEMENT, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiStatement)) {
            throw new IncorrectOperationException("Incorrect statement '" + text2 + "'");
        }
        PsiStatement psiStatement = (PsiStatement)element;
        if (psiStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createStatementFromText"));
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createExpressionFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, EXPRESSION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiExpression)) {
            throw new IncorrectOperationException("Incorrect expression '" + text2 + "'");
        }
        PsiExpression psiExpression = (PsiExpression)element;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createExpressionFromText"));
        }
        return psiExpression;
    }

    protected PsiJavaFile createDummyJavaFile(@NonNls String text2) {
        JavaFileType type2 = JavaFileType.INSTANCE;
        return (PsiJavaFile)PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText(DUMMY_FILE_NAME, type2, (CharSequence)text2);
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeParameterFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, TYPE_PARAMETER, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeParameter)) {
            throw new IncorrectOperationException("Incorrect type parameter '" + text2 + "'");
        }
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)element;
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeParameterFromText"));
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiComment createCommentFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createCommentFromText"));
        }
        PsiJavaFile aFile = this.createDummyJavaFile(text2);
        for (PsiElement aChildren : aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            if (!aChildren.getText().equals(text2)) break;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder(this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), context);
            PsiComment psiComment = comment;
            if (psiComment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createCommentFromText"));
            }
            return psiComment;
        }
        throw new IncorrectOperationException("Incorrect comment '" + text2 + "'");
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createEnumConstantFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, ENUM_CONSTANT, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiEnumConstant)) {
            throw new IncorrectOperationException("Incorrect enum constant '" + text2 + "'");
        }
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)element;
        if (psiEnumConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createEnumConstantFromText"));
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiType createPrimitiveType(@NotNull String text2, @NotNull PsiAnnotation[] annotations2) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createPrimitiveType"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createPrimitiveType"));
        }
        PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType(text2);
        if (primitiveType == null) {
            throw new IncorrectOperationException("Incorrect primitive type '" + text2 + "'");
        }
        PsiPrimitiveType psiPrimitiveType = annotations2.length == 0 ? primitiveType : new PsiPrimitiveType(text2, annotations2);
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createPrimitiveType"));
        }
        return psiPrimitiveType;
    }

    public static PsiPrimitiveType getPrimitiveType(String text2) {
        return PRIMITIVE_TYPES.get(text2);
    }

    protected static LanguageLevel level(@Nullable PsiElement context) {
        return context != null && context.isValid() ? PsiUtil.getLanguageLevel(context) : LanguageLevel.HIGHEST;
    }

    private static IncorrectOperationException newException(String msg2, DummyHolder holder) {
        Throwable cause;
        FileElement root = holder.getTreeElement();
        if (root instanceof JavaDummyElement && (cause = ((JavaDummyElement)root).getParserError()) != null) {
            return new IncorrectOperationException(msg2, cause);
        }
        return new IncorrectOperationException(msg2);
    }

    static {
        PRIMITIVE_TYPES.put(PsiType.BYTE.getCanonicalText(), PsiType.BYTE);
        PRIMITIVE_TYPES.put(PsiType.CHAR.getCanonicalText(), PsiType.CHAR);
        PRIMITIVE_TYPES.put(PsiType.DOUBLE.getCanonicalText(), PsiType.DOUBLE);
        PRIMITIVE_TYPES.put(PsiType.FLOAT.getCanonicalText(), PsiType.FLOAT);
        PRIMITIVE_TYPES.put(PsiType.INT.getCanonicalText(), PsiType.INT);
        PRIMITIVE_TYPES.put(PsiType.LONG.getCanonicalText(), PsiType.LONG);
        PRIMITIVE_TYPES.put(PsiType.SHORT.getCanonicalText(), PsiType.SHORT);
        PRIMITIVE_TYPES.put(PsiType.BOOLEAN.getCanonicalText(), PsiType.BOOLEAN);
        PRIMITIVE_TYPES.put(PsiType.VOID.getCanonicalText(), PsiType.VOID);
        PRIMITIVE_TYPES.put(PsiType.NULL.getCanonicalText(), PsiType.NULL);
    }
}

