/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.IOException;
import java.util.Collection;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class ZipFileCache {
    @NotNull
    public static ZipFile acquire(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/io/ZipFileCache", "acquire"));
        }
        ZipFile zipFile = new ZipFile(path);
        if (zipFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/io/ZipFileCache", "acquire"));
        }
        return zipFile;
    }

    public static void release(@NotNull ZipFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/openapi/util/io/ZipFileCache", "release"));
        }
        try {
            file2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void reset(Collection<String> paths) {
    }

    public static void stopBackgroundThread() {
    }
}

