/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\r\u001a\u00020\u0002\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0015"}, d2={"isExtensionFunctionType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isFunctionType", "isFunctionTypeOrSubtype", "isNonExtensionFunctionType", "isTypeAnnotatedWithExtensionFunctionType", "getFunctionTypeArgumentProjections", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "receiverType", "parameterTypes", "returnType", "getReceiverTypeFromFunctionType", "type", "getReturnTypeFromFunctionType", "getValueParameterTypesFromFunctionType", "isNumberedFunctionClassFqName", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "kotlin-compiler"})
public final class FunctionTypesKt {
    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FunctionTypesKt.isFunctionType($receiver) || (Boolean)DFS.dfsFromNode($receiver, isFunctionTypeOrSubtype.1.INSTANCE, new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<KotlinType, Boolean>(){
            private boolean result;

            public boolean beforeChildren(@NotNull KotlinType current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                if (FunctionTypesKt.isFunctionType(current)) {
                    this.result = true;
                }
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
        }) != false;
    }

    public static final boolean isFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor descriptor2 = $receiver.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && FunctionTypesKt.isNumberedFunctionClassFqName(DescriptorUtilsKt.getFqNameUnsafe(descriptor2));
    }

    public static final boolean isNonExtensionFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FunctionTypesKt.isFunctionType($receiver) && !FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    public static final boolean isExtensionFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FunctionTypesKt.isFunctionType($receiver) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(@NotNull KotlinType $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isNumberedFunctionClassFqName(@NotNull FqNameUnsafe fqName2) {
        String shortName;
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        List<Name> segments = fqName2.pathSegments();
        if (segments.size() != 2) {
            return false;
        }
        if (Intrinsics.areEqual(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME, CollectionsKt.first(segments)) ^ true) {
            return false;
        }
        String string = shortName = CollectionsKt.last(segments).asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "shortName");
        FqName fqName3 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        return BuiltInFictitiousFunctionClassFactory.Companion.isFunctionClassName(string, fqName3);
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl = FunctionTypesKt.isFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType(type2) ? CollectionsKt.first(type2.getArguments()).getType() : (KotlinType)null;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl = FunctionTypesKt.isFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType = CollectionsKt.last(type2.getArguments()).getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type.arguments.last().type");
        return kotlinType;
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl = FunctionTypesKt.isFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<TypeProjection> arguments = type2.getArguments();
        int first = FunctionTypesKt.isExtensionFunctionType(type2) ? 1 : 0;
        int last = arguments.size() - 1;
        boolean bl2 = first <= last;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Not an exact function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return arguments.subList(first, last);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @NotNull KotlinType returnType2) {
        void $receiver$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull(parameterTypes, "parameterTypes");
        Intrinsics.checkParameterIsNotNull(returnType2, "returnType");
        getFunctionTypeArgumentProjections.1 defaultProjection$ = getFunctionTypeArgumentProjections.1.INSTANCE;
        ArrayList<TypeProjectionImpl> arguments = new ArrayList<TypeProjectionImpl>(parameterTypes.size() + (receiverType != null ? 1 : 0) + 1);
        KotlinType kotlinType = receiverType;
        if (kotlinType != null) {
            object = kotlinType;
            KotlinType it = object;
            arguments.add(getFunctionTypeArgumentProjections.1.INSTANCE.invoke(it));
        }
        object = parameterTypes;
        for (Object item$iv : $receiver$iv) {
            void p1;
            KotlinType kotlinType2 = (KotlinType)item$iv;
            Collection collection = arguments;
            TypeProjectionImpl typeProjectionImpl = getFunctionTypeArgumentProjections.1.INSTANCE.invoke((KotlinType)p1);
            collection.add(typeProjectionImpl);
        }
        arguments.add(defaultProjection$.invoke(returnType2));
        return arguments;
    }
}

