/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskPropertyInfo;
import org.gradle.api.internal.project.taskfactory.TaskPropertyValue;
import org.gradle.api.internal.tasks.execution.TaskValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskClassValidator
implements TaskValidator,
Action<Task> {
    private final Set<TaskPropertyInfo> validatedProperties;
    private final Set<String> nonAnnotatedPropertyNames;

    public TaskClassValidator(Set<TaskPropertyInfo> validatedProperties, Set<String> nonAnnotatedPropertyNames) {
        this.validatedProperties = ImmutableSet.copyOf(validatedProperties);
        this.nonAnnotatedPropertyNames = ImmutableSet.copyOf(nonAnnotatedPropertyNames);
    }

    public void execute(Task task) {
    }

    public void addInputsAndOutputs(final TaskInternal task) {
        task.addValidator(this);
        for (final TaskPropertyInfo property : this.validatedProperties) {
            Callable<Object> futureValue = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return property.getValue(task).getValue();
                }
            };
            property.getConfigureAction().update(task, futureValue);
        }
    }

    @Override
    public void validate(TaskInternal task, Collection<String> messages) {
        ArrayList<TaskPropertyValue> propertyValues = new ArrayList<TaskPropertyValue>();
        for (TaskPropertyInfo property : this.validatedProperties) {
            propertyValues.add(property.getValue(task));
        }
        for (TaskPropertyValue propertyValue : propertyValues) {
            propertyValue.checkNotNull(messages);
        }
        for (TaskPropertyValue propertyValue : propertyValues) {
            propertyValue.checkValid(messages);
        }
    }

    public boolean hasAnythingToValidate() {
        return !this.validatedProperties.isEmpty();
    }

    public Set<TaskPropertyInfo> getValidatedProperties() {
        return this.validatedProperties;
    }

    public Set<String> getNonAnnotatedPropertyNames() {
        return this.nonAnnotatedPropertyNames;
    }
}

