/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Dependency;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.CollectionUtils;

public class DefaultDependencyMetadata
implements DependencyMetadata {
    private final ModuleVersionSelector requested;
    private final Map<String, List<String>> confs;
    private final Map<IvyArtifactName, Set<String>> dependencyArtifacts;
    private final Map<Exclude, Set<String>> excludes;
    private final boolean changing;
    private final boolean transitive;
    private final boolean force;
    private final String dynamicConstraintVersion;

    public DefaultDependencyMetadata(Dependency dependencyState) {
        this.requested = dependencyState.getRequested();
        this.changing = dependencyState.isChanging();
        this.transitive = dependencyState.isTransitive();
        this.force = dependencyState.isForce();
        this.dynamicConstraintVersion = dependencyState.getDynamicConstraintVersion();
        Map<String, List<String>> configMappings = dependencyState.getConfMappings();
        Set<String> configs = configMappings.keySet();
        this.confs = configs.isEmpty() ? Collections.emptyMap() : new LinkedHashMap(configs.size());
        for (String config : configs) {
            ArrayList mappings = new ArrayList(configMappings.get(config));
            this.confs.put(config, mappings);
        }
        List<Artifact> artifacts = dependencyState.getDependencyArtifacts();
        this.dependencyArtifacts = artifacts.isEmpty() ? Collections.emptyMap() : new HashMap(artifacts.size());
        for (Artifact dependencyArtifact : artifacts) {
            this.dependencyArtifacts.put(dependencyArtifact.getArtifactName(), dependencyArtifact.getConfigurations());
        }
        List<Exclude> dependencyExcludes = dependencyState.getDependencyExcludes();
        this.excludes = dependencyExcludes.isEmpty() ? Collections.emptyMap() : new HashMap(dependencyExcludes.size());
        for (Exclude exclude : dependencyExcludes) {
            this.excludes.put(exclude, Sets.newHashSet((Object[])exclude.getConfigurations()));
        }
    }

    public DefaultDependencyMetadata(ModuleVersionIdentifier moduleVersionIdentifier) {
        this(new DefaultModuleVersionSelector(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), moduleVersionIdentifier.getVersion()), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), moduleVersionIdentifier.getVersion(), false, true);
    }

    public DefaultDependencyMetadata(ModuleComponentIdentifier componentIdentifier) {
        this(new DefaultModuleVersionSelector(componentIdentifier.getGroup(), componentIdentifier.getModule(), componentIdentifier.getVersion()), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), componentIdentifier.getVersion(), false, true);
    }

    public DefaultDependencyMetadata(ModuleVersionSelector requested, Map<String, List<String>> confs, Map<IvyArtifactName, Set<String>> dependencyArtifacts, Map<Exclude, Set<String>> excludes, String dynamicConstraintVersion, boolean changing, boolean transitive) {
        this.requested = requested;
        this.confs = confs;
        this.dependencyArtifacts = dependencyArtifacts;
        this.excludes = excludes;
        this.changing = changing;
        this.transitive = transitive;
        this.dynamicConstraintVersion = dynamicConstraintVersion;
        this.force = false;
    }

    public String toString() {
        return "dependency: " + this.requested;
    }

    @Override
    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    @Override
    public String[] getModuleConfigurations() {
        return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
    }

    @Override
    public String[] getDependencyConfigurations(final String moduleConfiguration, final String requestedConfiguration) {
        List<String> wildcardConfigs;
        Set mappedConfigs = Sets.newLinkedHashSet();
        List<String> matchedConfigs = this.confs.get(moduleConfiguration);
        if (matchedConfigs == null) {
            matchedConfigs = this.confs.get("%");
        }
        if (matchedConfigs != null) {
            mappedConfigs.addAll(matchedConfigs);
        }
        if ((wildcardConfigs = this.confs.get("*")) != null) {
            mappedConfigs.addAll(wildcardConfigs);
        }
        if ((mappedConfigs = CollectionUtils.collect((Set)mappedConfigs, (Transformer)new Transformer<String, String>(){

            public String transform(String original) {
                if (original.startsWith("@")) {
                    return moduleConfiguration + original.substring(1);
                }
                if (original.startsWith("#")) {
                    return requestedConfiguration + original.substring(1);
                }
                return original;
            }
        })).remove("*")) {
            StringBuilder r = new StringBuilder("*");
            for (String c : mappedConfigs) {
                if (!c.startsWith("!")) continue;
                r.append(c);
            }
            return new String[]{r.toString()};
        }
        return mappedConfigs.toArray(new String[mappedConfigs.size()]);
    }

    @Override
    public List<Exclude> getExcludes(Collection<String> configurations) {
        ArrayList rules = Lists.newArrayList();
        for (Map.Entry<Exclude, Set<String>> entry : this.excludes.entrySet()) {
            Exclude exclude = entry.getKey();
            Set<String> ruleConfigurations = entry.getValue();
            if (!this.include(ruleConfigurations, configurations)) continue;
            rules.add(exclude);
        }
        return rules;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.dynamicConstraintVersion;
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata fromConfiguration, ConfigurationMetadata toConfiguration) {
        Set<String> includedConfigurations = fromConfiguration.getHierarchy();
        LinkedHashSet artifacts = Sets.newLinkedHashSet();
        for (Map.Entry<IvyArtifactName, Set<String>> entry : this.dependencyArtifacts.entrySet()) {
            IvyArtifactName ivyArtifactName = entry.getKey();
            Set<String> artifactConfigurations = entry.getValue();
            if (!this.include(artifactConfigurations, includedConfigurations)) continue;
            ComponentArtifactMetadata artifact = toConfiguration.artifact(ivyArtifactName);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private boolean include(Iterable<String> configurations, Collection<String> acceptedConfigurations) {
        for (String configuration : configurations) {
            if (configuration.equals("*")) {
                return true;
            }
            if (!acceptedConfigurations.contains(configuration)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.dependencyArtifacts.keySet();
    }

    @Override
    public DependencyMetadata withRequestedVersion(String requestedVersion) {
        if (requestedVersion.equals(this.requested.getVersion())) {
            return this;
        }
        ModuleVersionSelector newRequested = DefaultModuleVersionSelector.newSelector(this.requested.getGroup(), this.requested.getName(), requestedVersion);
        return this.withRequested(newRequested);
    }

    private DependencyMetadata withRequested(ModuleVersionSelector newRequested) {
        if (newRequested.equals(this.requested)) {
            return this;
        }
        return new DefaultDependencyMetadata(newRequested, this.confs, this.dependencyArtifacts, this.excludes, this.dynamicConstraintVersion, this.changing, this.transitive);
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleVersionSelector requestedVersion = DefaultModuleVersionSelector.newSelector(moduleTarget.getGroup(), moduleTarget.getModule(), moduleTarget.getVersion());
            if (requestedVersion.equals(this.requested)) {
                return this;
            }
            return this.withRequested(requestedVersion);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget.getProjectPath(), this.requested, this.confs, this.dependencyArtifacts, this.excludes, this.dynamicConstraintVersion, this.changing, this.transitive);
        }
        throw new AssertionError();
    }

    @Override
    public DependencyMetadata withChanging() {
        if (this.changing) {
            return this;
        }
        return new DefaultDependencyMetadata(this.requested, this.confs, this.dependencyArtifacts, this.excludes, this.dynamicConstraintVersion, true, this.transitive);
    }

    @Override
    public ComponentSelector getSelector() {
        return DefaultModuleComponentSelector.newSelector(this.requested.getGroup(), this.requested.getName(), this.requested.getVersion());
    }
}

