/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;

public class DefaultLocalComponentMetadata
implements LocalComponentMetadata,
BuildableLocalComponentMetadata {
    private final Map<String, DefaultLocalConfigurationMetadata> allConfigurations = Maps.newHashMap();
    private final Multimap<String, ComponentArtifactMetadata> allArtifacts = ArrayListMultimap.create();
    private final List<DependencyMetadata> allDependencies = Lists.newArrayList();
    private final List<Exclude> allExcludes = Lists.newArrayList();
    private final ModuleVersionIdentifier id;
    private final ComponentIdentifier componentIdentifier;
    private final String status;

    public DefaultLocalComponentMetadata(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier, String status) {
        this.id = id;
        this.componentIdentifier = componentIdentifier;
        this.status = status;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public void addArtifacts(String configuration, Iterable<? extends PublishArtifact> artifacts) {
        for (PublishArtifact publishArtifact : artifacts) {
            PublishArtifactLocalArtifactMetadata artifactMetadata = new PublishArtifactLocalArtifactMetadata(this.componentIdentifier, this.componentIdentifier.getDisplayName(), publishArtifact);
            this.addArtifact(configuration, artifactMetadata);
        }
    }

    public void addArtifact(String configuration, ComponentArtifactMetadata artifactMetadata) {
        this.allArtifacts.put((Object)configuration, (Object)artifactMetadata);
    }

    @Override
    public void addConfiguration(String name, String description, Set<String> extendsFrom, Set<String> hierarchy, boolean visible, boolean transitive, TaskDependency buildDependencies) {
        DefaultLocalConfigurationMetadata conf = new DefaultLocalConfigurationMetadata(name, description, visible, transitive, extendsFrom, hierarchy, buildDependencies);
        this.allConfigurations.put(name, conf);
    }

    @Override
    public void addDependency(DependencyMetadata dependency) {
        this.allDependencies.add(dependency);
    }

    @Override
    public void addExclude(Exclude exclude) {
        this.allExcludes.add(exclude);
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleSource getSource() {
        return null;
    }

    @Override
    public ComponentResolveMetadata withSource(ModuleSource source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isGenerated() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return DEFAULT_STATUS_SCHEME;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public List<DependencyMetadata> getDependencies() {
        return this.allDependencies;
    }

    public List<Exclude> getExcludeRules() {
        return this.allExcludes;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.allConfigurations.keySet();
    }

    @Override
    public DefaultLocalConfigurationMetadata getConfiguration(String name) {
        return this.allConfigurations.get(name);
    }

    static Set<ComponentArtifactMetadata> getArtifacts(Set<String> configurationHierarchy, Multimap<String, ComponentArtifactMetadata> allArtifacts) {
        LinkedHashSet artifacts = Sets.newLinkedHashSet();
        for (String config : configurationHierarchy) {
            artifacts.addAll(allArtifacts.get((Object)config));
        }
        return artifacts;
    }

    private class DefaultLocalConfigurationMetadata
    implements LocalConfigurationMetadata {
        private final String name;
        private final String description;
        private final boolean transitive;
        private final boolean visible;
        private final Set<String> hierarchy;
        private final Set<String> extendsFrom;
        private final TaskDependency buildDependencies;
        private List<DependencyMetadata> configurationDependencies;
        private LinkedHashSet<Exclude> configurationExcludes;

        private DefaultLocalConfigurationMetadata(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, Set<String> hierarchy, TaskDependency buildDependencies) {
            this.name = name;
            this.description = description;
            this.transitive = transitive;
            this.visible = visible;
            this.hierarchy = hierarchy;
            this.extendsFrom = extendsFrom;
            this.buildDependencies = buildDependencies;
        }

        public String toString() {
            return DefaultLocalComponentMetadata.this.componentIdentifier.getDisplayName() + ":" + this.name;
        }

        @Override
        public ComponentResolveMetadata getComponent() {
            return DefaultLocalComponentMetadata.this;
        }

        @Override
        public TaskDependency getDirectBuildDependencies() {
            return this.buildDependencies;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Set<String> getExtendsFrom() {
            return this.extendsFrom;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public List<DependencyMetadata> getDependencies() {
            if (this.configurationDependencies == null) {
                this.configurationDependencies = new ArrayList<DependencyMetadata>();
                for (DependencyMetadata dependency : DefaultLocalComponentMetadata.this.allDependencies) {
                    if (!this.include(dependency)) continue;
                    this.configurationDependencies.add(dependency);
                }
            }
            return this.configurationDependencies;
        }

        private boolean include(DependencyMetadata dependency) {
            String[] moduleConfigurations = dependency.getModuleConfigurations();
            for (int i = 0; i < moduleConfigurations.length; ++i) {
                String moduleConfiguration = moduleConfigurations[i];
                if (moduleConfiguration.equals("%") || this.hierarchy.contains(moduleConfiguration)) {
                    return true;
                }
                if (!moduleConfiguration.equals("*")) continue;
                boolean include = true;
                for (int j = i + 1; j < moduleConfigurations.length && moduleConfigurations[j].startsWith("!"); ++j) {
                    if (!moduleConfigurations[j].substring(1).equals(this.getName())) continue;
                    include = false;
                    break;
                }
                if (!include) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Exclude> getExcludes() {
            if (this.configurationExcludes == null) {
                this.configurationExcludes = new LinkedHashSet();
                block0: for (Exclude exclude : DefaultLocalComponentMetadata.this.allExcludes) {
                    for (String config : exclude.getConfigurations()) {
                        if (!this.hierarchy.contains(config)) continue;
                        this.configurationExcludes.add(exclude);
                        continue block0;
                    }
                }
            }
            return this.configurationExcludes;
        }

        @Override
        public Set<ComponentArtifactMetadata> getArtifacts() {
            return DefaultLocalComponentMetadata.getArtifacts(this.getHierarchy(), (Multimap<String, ComponentArtifactMetadata>)DefaultLocalComponentMetadata.this.allArtifacts);
        }

        @Override
        public ComponentArtifactMetadata artifact(IvyArtifactName ivyArtifactName) {
            for (ComponentArtifactMetadata candidate : this.getArtifacts()) {
                if (!candidate.getName().equals(ivyArtifactName)) continue;
                return candidate;
            }
            return new MissingLocalArtifactMetadata(DefaultLocalComponentMetadata.this.componentIdentifier, DefaultLocalComponentMetadata.this.id.toString(), ivyArtifactName);
        }
    }
}

