/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.Dependency;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.descriptor.MutableModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultDependencyMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.util.CollectionUtils;

abstract class AbstractModuleComponentResolveMetadata
implements MutableModuleComponentResolveMetadata {
    private final ModuleDescriptorState descriptor;
    private ModuleVersionIdentifier moduleVersionIdentifier;
    private ModuleComponentIdentifier componentIdentifier;
    private boolean changing;
    private boolean generated;
    private String status;
    private List<String> statusScheme = DEFAULT_STATUS_SCHEME;
    private ModuleSource moduleSource;
    private Map<String, DefaultConfigurationMetadata> configurations;
    private Multimap<String, ModuleComponentArtifactMetadata> artifactsByConfig;
    private List<DependencyMetadata> dependencies;
    private List<Exclude> excludes;

    public AbstractModuleComponentResolveMetadata(ModuleComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier, ModuleDescriptorState moduleDescriptor) {
        this.descriptor = moduleDescriptor;
        this.componentIdentifier = componentIdentifier;
        this.moduleVersionIdentifier = moduleVersionIdentifier;
        this.generated = moduleDescriptor.isGenerated();
        this.status = moduleDescriptor.getStatus();
        this.configurations = this.populateConfigurationsFromDescriptor(moduleDescriptor);
        this.artifactsByConfig = AbstractModuleComponentResolveMetadata.populateArtifactsFromDescriptor(componentIdentifier, moduleDescriptor);
        this.dependencies = AbstractModuleComponentResolveMetadata.populateDependenciesFromDescriptor(moduleDescriptor);
        this.excludes = moduleDescriptor.getExcludes();
    }

    protected static ModuleDescriptorState createModuleDescriptor(ModuleComponentIdentifier componentIdentifier, Set<IvyArtifactName> componentArtifacts) {
        MutableModuleDescriptorState moduleDescriptorState = new MutableModuleDescriptorState(componentIdentifier);
        moduleDescriptorState.addConfiguration("default", true, true, Collections.<String>emptySet());
        for (IvyArtifactName artifactName : componentArtifacts) {
            moduleDescriptorState.addArtifact(artifactName, Collections.singleton("default"));
        }
        if (componentArtifacts.isEmpty()) {
            DefaultIvyArtifactName defaultArtifact = new DefaultIvyArtifactName(componentIdentifier.getModule(), "jar", "jar");
            moduleDescriptorState.addArtifact(defaultArtifact, Collections.singleton("default"));
        }
        return moduleDescriptorState;
    }

    protected void copyTo(AbstractModuleComponentResolveMetadata copy) {
        copy.changing = this.changing;
        copy.status = this.status;
        copy.statusScheme = this.statusScheme;
        copy.moduleSource = this.moduleSource;
        copy.artifactsByConfig = this.artifactsByConfig;
        copy.dependencies = this.dependencies;
        copy.excludes = this.excludes;
    }

    @Override
    public ModuleDescriptorState getDescriptor() {
        return this.descriptor;
    }

    @Override
    public abstract AbstractModuleComponentResolveMetadata copy();

    @Override
    public MutableModuleComponentResolveMetadata withSource(ModuleSource source) {
        AbstractModuleComponentResolveMetadata copy = this.copy();
        copy.setModuleSource(source);
        return copy;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isGenerated() {
        return this.generated;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public void setComponentId(ModuleComponentIdentifier componentId) {
        this.componentIdentifier = componentId;
        this.setId(DefaultModuleVersionIdentifier.newId(componentId));
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.moduleVersionIdentifier;
    }

    public void setId(ModuleVersionIdentifier moduleVersionIdentifier) {
        this.moduleVersionIdentifier = moduleVersionIdentifier;
    }

    @Override
    public void setChanging(boolean changing) {
        this.changing = changing;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void setStatusScheme(List<String> statusScheme) {
        this.statusScheme = statusScheme;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    @Override
    public void setSource(ModuleSource source) {
        this.moduleSource = source;
    }

    public void setModuleSource(ModuleSource moduleSource) {
        this.moduleSource = moduleSource;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurations.keySet();
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getComponentId(), ivyArtifactName);
    }

    @Override
    public void setArtifacts(Iterable<? extends ModuleComponentArtifactMetadata> artifacts) {
        this.artifactsByConfig = LinkedHashMultimap.create();
        for (String config : this.getConfigurationNames()) {
            this.artifactsByConfig.putAll((Object)config, artifacts);
        }
    }

    private static Multimap<String, ModuleComponentArtifactMetadata> populateArtifactsFromDescriptor(ModuleComponentIdentifier componentId, ModuleDescriptorState descriptor) {
        LinkedHashMultimap artifactsByConfig = LinkedHashMultimap.create();
        for (Artifact artifact : descriptor.getArtifacts()) {
            DefaultModuleComponentArtifactMetadata artifactMetadata = new DefaultModuleComponentArtifactMetadata(componentId, artifact.getArtifactName());
            for (String configuration : artifact.getConfigurations()) {
                artifactsByConfig.put((Object)configuration, (Object)artifactMetadata);
            }
        }
        return artifactsByConfig;
    }

    private static List<DependencyMetadata> populateDependenciesFromDescriptor(ModuleDescriptorState moduleDescriptor) {
        List<Dependency> dependencies = moduleDescriptor.getDependencies();
        ArrayList<DependencyMetadata> result = new ArrayList<DependencyMetadata>(dependencies.size());
        for (Dependency dependency : dependencies) {
            result.add(new DefaultDependencyMetadata(dependency));
        }
        return result;
    }

    @Override
    public List<DependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setDependencies(Iterable<? extends DependencyMetadata> dependencies) {
        this.dependencies = CollectionUtils.toList(dependencies);
        for (DefaultConfigurationMetadata configuration : this.configurations.values()) {
            configuration.configDependencies = null;
        }
    }

    @Override
    public DefaultConfigurationMetadata getConfiguration(String name) {
        return this.configurations.get(name);
    }

    private Map<String, DefaultConfigurationMetadata> populateConfigurationsFromDescriptor(ModuleDescriptorState moduleDescriptor) {
        Set<String> configurationsNames = moduleDescriptor.getConfigurationsNames();
        HashMap<String, DefaultConfigurationMetadata> configurations = new HashMap<String, DefaultConfigurationMetadata>(configurationsNames.size());
        for (String configName : configurationsNames) {
            this.populateConfigurationFromDescriptor(configName, moduleDescriptor, configurations);
        }
        return configurations;
    }

    private DefaultConfigurationMetadata populateConfigurationFromDescriptor(String name, ModuleDescriptorState moduleDescriptor, Map<String, DefaultConfigurationMetadata> configurations) {
        DefaultConfigurationMetadata populated = configurations.get(name);
        if (populated != null) {
            return populated;
        }
        Configuration descriptorConfiguration = moduleDescriptor.getConfiguration(name);
        List<String> extendsFrom = descriptorConfiguration.getExtendsFrom();
        boolean transitive = descriptorConfiguration.isTransitive();
        boolean visible = descriptorConfiguration.isVisible();
        if (extendsFrom.isEmpty()) {
            populated = new DefaultConfigurationMetadata(name, transitive, visible);
            configurations.put(name, populated);
            return populated;
        }
        if (extendsFrom.size() == 1) {
            populated = new DefaultConfigurationMetadata(name, transitive, visible, Collections.singletonList(this.populateConfigurationFromDescriptor(extendsFrom.get(0), moduleDescriptor, configurations)));
            configurations.put(name, populated);
            return populated;
        }
        ArrayList<DefaultConfigurationMetadata> hierarchy = new ArrayList<DefaultConfigurationMetadata>(extendsFrom.size());
        for (String confName : extendsFrom) {
            hierarchy.add(this.populateConfigurationFromDescriptor(confName, moduleDescriptor, configurations));
        }
        populated = new DefaultConfigurationMetadata(name, transitive, visible, hierarchy);
        configurations.put(name, populated);
        return populated;
    }

    private class DefaultConfigurationMetadata
    implements ConfigurationMetadata {
        private final String name;
        private final List<DefaultConfigurationMetadata> parents;
        private List<DependencyMetadata> configDependencies;
        private Set<ComponentArtifactMetadata> artifacts;
        private LinkedHashSet<Exclude> configExcludes;
        private final boolean transitive;
        private final boolean visible;

        private DefaultConfigurationMetadata(String name, boolean transitive, boolean visible, List<DefaultConfigurationMetadata> parents) {
            this.name = name;
            this.parents = parents;
            this.transitive = transitive;
            this.visible = visible;
        }

        private DefaultConfigurationMetadata(String name, boolean transitive, boolean visible) {
            this(name, transitive, visible, (List<DefaultConfigurationMetadata>)null);
        }

        public String toString() {
            return this.getComponent().getComponentId() + ":" + this.name;
        }

        @Override
        public ComponentResolveMetadata getComponent() {
            return AbstractModuleComponentResolveMetadata.this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getHierarchy() {
            if (this.parents == null) {
                return Collections.singleton(this.name);
            }
            LinkedHashSet<String> hierarchy = new LinkedHashSet<String>(1 + this.parents.size());
            this.populateHierarchy(hierarchy);
            return hierarchy;
        }

        private void populateHierarchy(Set<String> accumulator) {
            accumulator.add(this.name);
            if (this.parents != null) {
                for (DefaultConfigurationMetadata parent : this.parents) {
                    parent.populateHierarchy(accumulator);
                }
            }
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public List<DependencyMetadata> getDependencies() {
            if (this.configDependencies == null) {
                this.configDependencies = new ArrayList<DependencyMetadata>();
                for (DependencyMetadata dependency : AbstractModuleComponentResolveMetadata.this.dependencies) {
                    if (!this.include(dependency)) continue;
                    this.configDependencies.add(dependency);
                }
            }
            return this.configDependencies;
        }

        private boolean include(DependencyMetadata dependency) {
            String[] moduleConfigurations = dependency.getModuleConfigurations();
            Set<String> hierarchy = this.getHierarchy();
            for (int i = 0; i < moduleConfigurations.length; ++i) {
                String moduleConfiguration = moduleConfigurations[i];
                if (moduleConfiguration.equals("%") || hierarchy.contains(moduleConfiguration)) {
                    return true;
                }
                if (!moduleConfiguration.equals("*")) continue;
                boolean include = true;
                for (int j = i + 1; j < moduleConfigurations.length && moduleConfigurations[j].startsWith("!"); ++j) {
                    if (!moduleConfigurations[j].substring(1).equals(this.getName())) continue;
                    include = false;
                    break;
                }
                if (!include) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Exclude> getExcludes() {
            if (this.configExcludes == null) {
                this.populateExcludeRulesFromDescriptor();
            }
            return this.configExcludes;
        }

        private void populateExcludeRulesFromDescriptor() {
            this.configExcludes = new LinkedHashSet();
            Set<String> hierarchy = this.getHierarchy();
            block0: for (Exclude exclude : AbstractModuleComponentResolveMetadata.this.excludes) {
                for (String config : exclude.getConfigurations()) {
                    if (!hierarchy.contains(config)) continue;
                    this.configExcludes.add(exclude);
                    continue block0;
                }
            }
        }

        @Override
        public Set<ComponentArtifactMetadata> getArtifacts() {
            if (this.artifacts == null) {
                this.artifacts = this.getArtifactsForConfiguration(this, new LinkedHashSet<ComponentArtifactMetadata>(), new HashSet<String>());
            }
            return this.artifacts;
        }

        protected Set<ComponentArtifactMetadata> getArtifactsForConfiguration(ConfigurationMetadata configurationMetadata, Set<ComponentArtifactMetadata> accumulator, HashSet<String> visited) {
            String name = configurationMetadata.getName();
            if (visited.contains(name)) {
                return accumulator;
            }
            visited.add(name);
            accumulator.addAll(AbstractModuleComponentResolveMetadata.this.artifactsByConfig.get((Object)name));
            if (this.parents != null) {
                for (DefaultConfigurationMetadata parent : this.parents) {
                    this.getArtifactsForConfiguration(parent, accumulator, visited);
                }
            }
            return accumulator;
        }

        @Override
        public ModuleComponentArtifactMetadata artifact(IvyArtifactName artifact) {
            return new DefaultModuleComponentArtifactMetadata(AbstractModuleComponentResolveMetadata.this.getComponentId(), artifact);
        }
    }
}

