/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.descriptor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.Dependency;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;

public class MutableModuleDescriptorState
extends ModuleDescriptorState {
    public MutableModuleDescriptorState(ModuleComponentIdentifier componentIdentifier) {
        super(componentIdentifier, "integration", true);
    }

    public MutableModuleDescriptorState(ModuleComponentIdentifier componentIdentifier, String status, boolean generated) {
        super(componentIdentifier, status, generated);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setPublicationDate(Date publicationDate) {
        this.publicationDate = publicationDate;
    }

    public void addConfiguration(String name, boolean transitive, boolean visible, Collection<String> extendsFrom) {
        Configuration configuration = new Configuration(name, transitive, visible, extendsFrom);
        this.configurations.put(name, configuration);
    }

    public void addExclude(Exclude exclude) {
        this.excludes.add(exclude);
    }

    public Dependency addDependency(ModuleVersionSelector requested) {
        return this.addDependency(requested, requested.getVersion(), false, false, true);
    }

    public Dependency addDependency(ModuleVersionSelector requested, String dynamicConstraintVersion, boolean force, boolean changing, boolean transitive) {
        Dependency dependency = new Dependency(requested, dynamicConstraintVersion, force, changing, transitive);
        this.dependencies.add(dependency);
        return dependency;
    }

    public void addDependency(DependencyMetadata dependencyMetadata) {
        Dependency dependency = new Dependency(dependencyMetadata.getRequested(), dependencyMetadata.getDynamicConstraintVersion(), dependencyMetadata.isForce(), dependencyMetadata.isChanging(), dependencyMetadata.isTransitive());
        ArrayList configurations = Lists.newArrayList((Object[])dependencyMetadata.getModuleConfigurations());
        for (String moduleConfiguration : configurations) {
            for (String dependencyConfiguration : dependencyMetadata.getDependencyConfigurations(moduleConfiguration, moduleConfiguration)) {
                dependency.addDependencyConfiguration(moduleConfiguration, dependencyConfiguration);
            }
        }
        for (IvyArtifactName artifactName : dependencyMetadata.getArtifacts()) {
            dependency.addArtifact(artifactName, configurations);
        }
        this.dependencies.add(dependency);
    }
}

