/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.descriptor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.Dependency;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;

public class ModuleDescriptorState {
    private final ModuleComponentIdentifier componentIdentifier;
    protected final Map<String, Configuration> configurations;
    protected final List<Exclude> excludes;
    protected final List<Dependency> dependencies;
    private final List<Artifact> artifacts = Lists.newArrayList();
    private final String status;
    private final boolean generated;
    private final Map<NamespaceId, String> extraInfo;
    protected String description;
    protected String branch;
    protected Date publicationDate;

    public ModuleDescriptorState(ModuleComponentIdentifier componentIdentifier, String status, boolean generated) {
        this.componentIdentifier = componentIdentifier;
        this.branch = null;
        this.description = null;
        this.publicationDate = new Date();
        this.status = status;
        this.generated = generated;
        this.extraInfo = Maps.newHashMap();
        this.configurations = Maps.newHashMap();
        this.excludes = Lists.newArrayList();
        this.dependencies = Lists.newArrayList();
    }

    public ModuleComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public Map<NamespaceId, String> getExtraInfo() {
        return this.extraInfo;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public String getStatus() {
        return this.status;
    }

    public Set<String> getConfigurationsNames() {
        return this.configurations.keySet();
    }

    public Configuration getConfiguration(String name) {
        return this.configurations.get(name);
    }

    public Collection<Configuration> getConfigurations() {
        return this.configurations.values();
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void addArtifact(IvyArtifactName newArtifact, Set<String> configurations) {
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("Artifact should be attached to at least one configuration.");
        }
        Set<String> configurationNames = this.getConfigurationsNames();
        for (String configuration : configurations) {
            if (configurationNames.contains(configuration)) continue;
            throw new IllegalArgumentException("Cannot add artifact '" + newArtifact + "' to configuration '" + configuration + "' of module " + this.getComponentIdentifier() + " because this configuration doesn't exist!");
        }
        Artifact artifact = this.findOrCreate(newArtifact);
        artifact.getConfigurations().addAll(configurations);
    }

    private Artifact findOrCreate(IvyArtifactName artifactName) {
        for (Artifact existingArtifact : this.artifacts) {
            if (!existingArtifact.getArtifactName().equals(artifactName)) continue;
            return existingArtifact;
        }
        Artifact newArtifact = new Artifact(artifactName);
        this.artifacts.add(newArtifact);
        return newArtifact;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Exclude> getExcludes() {
        return this.excludes;
    }
}

