/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.descriptor;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultExclude
implements Exclude {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName artifact;
    private final String[] configurations;
    private final String patternMatcher;

    public DefaultExclude(String group, String module, String artifact, String type, String extension, String[] configurations, String patternMatcher) {
        this.moduleId = DefaultModuleIdentifier.newId(group, module);
        this.artifact = new DefaultIvyArtifactName(artifact, type, extension);
        this.configurations = configurations;
        this.patternMatcher = patternMatcher;
    }

    public DefaultExclude(String group, String module, String[] configurations, String patternMatcher) {
        this.moduleId = DefaultModuleIdentifier.newId(group, module);
        this.artifact = new DefaultIvyArtifactName("*", "*", "*");
        this.configurations = configurations;
        this.patternMatcher = patternMatcher;
    }

    public DefaultExclude(String group, String module) {
        this.moduleId = DefaultModuleIdentifier.newId(group, module);
        this.artifact = new DefaultIvyArtifactName("*", "*", "*");
        this.configurations = new String[0];
        this.patternMatcher = "exact";
    }

    @Override
    public ModuleIdentifier getModuleId() {
        return this.moduleId;
    }

    @Override
    public IvyArtifactName getArtifact() {
        return this.artifact;
    }

    @Override
    public String[] getConfigurations() {
        return this.configurations;
    }

    @Override
    public String getMatcher() {
        return this.patternMatcher;
    }
}

