/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResultBuilder;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public class ResolvedLocalComponentsResultGraphVisitor
implements DependencyGraphVisitor {
    private final ResolvedLocalComponentsResultBuilder builder;
    private ComponentIdentifier rootId;

    public ResolvedLocalComponentsResultGraphVisitor(ResolvedLocalComponentsResultBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void start(DependencyGraphNode root) {
        this.rootId = root.getComponentId();
    }

    @Override
    public void visitNode(DependencyGraphNode resolvedConfiguration) {
        ConfigurationMetadata configurationMetadata;
        if (this.rootId.equals(resolvedConfiguration.getComponentId())) {
            return;
        }
        ComponentIdentifier componentId = resolvedConfiguration.getComponentId();
        if (componentId instanceof ProjectComponentIdentifier) {
            this.builder.projectConfigurationResolved((ProjectComponentIdentifier)componentId, resolvedConfiguration.getNodeId().getConfiguration());
        }
        if ((configurationMetadata = resolvedConfiguration.getMetaData()) instanceof LocalConfigurationMetadata) {
            this.builder.localComponentResolved(componentId, ((LocalConfigurationMetadata)configurationMetadata).getDirectBuildDependencies());
        }
    }

    @Override
    public void visitEdge(DependencyGraphNode resolvedConfiguration) {
    }

    @Override
    public void finish(DependencyGraphNode root) {
    }
}

