/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DependencyToConfigurationResolver;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;

public class DefaultDependencyToConfigurationResolver
implements DependencyToConfigurationResolver {
    @Override
    public Set<ConfigurationMetadata> resolveTargetConfigurations(DependencyMetadata dependencyMetadata, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent) {
        LinkedHashSet<String> targetConfigurationNames = new LinkedHashSet<String>();
        for (String config : dependencyMetadata.getModuleConfigurations()) {
            if (config.equals("*") || config.equals("%")) {
                this.collectTargetConfiguration(dependencyMetadata, fromConfiguration, fromConfiguration.getName(), targetComponent, targetConfigurationNames);
                continue;
            }
            if (!fromConfiguration.getHierarchy().contains(config)) continue;
            this.collectTargetConfiguration(dependencyMetadata, fromConfiguration, config, targetComponent, targetConfigurationNames);
        }
        LinkedHashSet<ConfigurationMetadata> targets = new LinkedHashSet<ConfigurationMetadata>();
        for (String targetConfigurationName : targetConfigurationNames) {
            ConfigurationMetadata targetConfiguration = targetComponent.getConfiguration(targetConfigurationName);
            targets.add(targetConfiguration);
        }
        return targets;
    }

    private void collectTargetConfiguration(DependencyMetadata dependencyDescriptor, ConfigurationMetadata fromConfiguration, String mappingRhs, ComponentResolveMetadata targetModule, Collection<String> targetConfigs) {
        String[] dependencyConfigurations;
        for (String target : dependencyConfigurations = dependencyDescriptor.getDependencyConfigurations(mappingRhs, fromConfiguration.getName())) {
            String candidate = target;
            int startFallback = candidate.indexOf(40);
            if (startFallback >= 0 && candidate.charAt(candidate.length() - 1) == ')') {
                String preferred = candidate.substring(0, startFallback);
                if (targetModule.getConfiguration(preferred) != null) {
                    targetConfigs.add(preferred);
                    continue;
                }
                candidate = candidate.substring(startFallback + 1, candidate.length() - 1);
            }
            if (candidate.equals("*")) {
                for (String configName : targetModule.getConfigurationNames()) {
                    if (!targetModule.getConfiguration(configName).isVisible()) continue;
                    targetConfigs.add(configName);
                }
                continue;
            }
            if (targetModule.getConfiguration(candidate) != null) {
                targetConfigs.add(candidate);
                continue;
            }
            throw new RuntimeException(String.format("Module version %s, configuration '%s' declares a dependency on configuration '%s' which is not declared in the module descriptor for %s", fromConfiguration.getComponent().getId(), fromConfiguration.getName(), target, targetModule.getId()));
        }
    }
}

