/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeBuildContext;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeProjectComponentArtifactMetadata;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultBuildableCompositeBuildContext;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;

public class CompositeContextBuilder
implements BuildActionRunner {
    private final DefaultBuildableCompositeBuildContext context = new DefaultBuildableCompositeBuildContext();
    private final boolean propagateFailures;

    public CompositeContextBuilder(boolean propagateFailures) {
        this.propagateFailures = propagateFailures;
    }

    public void run(BuildAction action, BuildController buildController) {
        block3: {
            try {
                GradleInternal gradle = buildController.configure();
                ProjectInternal rootProject = gradle.getRootProject();
                String participantName = rootProject.getName();
                for (Project project : rootProject.getAllprojects()) {
                    this.registerProject(participantName, (ProjectInternal)project);
                }
            }
            catch (ReportedException e) {
                if (!this.propagateFailures) break block3;
                throw e;
            }
        }
    }

    private void registerProject(String buildName, ProjectInternal project) {
        File buildDir = project.getRootDir();
        ProjectComponentRegistry projectComponentProvider = (ProjectComponentRegistry)project.getServices().get(ProjectComponentRegistry.class);
        ProjectComponentIdentifier originalIdentifier = DefaultProjectComponentIdentifier.newId(project.getPath());
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)projectComponentProvider.getProject(originalIdentifier);
        DefaultProjectComponentIdentifier componentIdentifier = new DefaultProjectComponentIdentifier(this.createExternalProjectPath(buildName, project.getPath()));
        LocalComponentMetadata compositeComponent = this.createCompositeCopy(buildName, componentIdentifier, originalComponent, buildDir);
        this.context.register(compositeComponent.getId().getModule(), componentIdentifier, compositeComponent, project.getProjectDir());
        for (ComponentArtifactMetadata artifactMetaData : projectComponentProvider.getAdditionalArtifacts(originalIdentifier)) {
            this.context.registerAdditionalArtifact(componentIdentifier, this.createCompositeCopy(componentIdentifier, artifactMetaData, buildDir));
        }
    }

    private LocalComponentMetadata createCompositeCopy(String buildName, ProjectComponentIdentifier componentIdentifier, DefaultLocalComponentMetadata originalComponentMetadata, File buildDir) {
        DefaultLocalComponentMetadata compositeComponentMetadata = new DefaultLocalComponentMetadata(originalComponentMetadata.getId(), (ComponentIdentifier)componentIdentifier, originalComponentMetadata.getStatus());
        for (String configurationName : originalComponentMetadata.getConfigurationNames()) {
            DefaultLocalComponentMetadata.DefaultLocalConfigurationMetadata originalConfiguration = originalComponentMetadata.getConfiguration(configurationName);
            compositeComponentMetadata.addConfiguration(configurationName, originalConfiguration.getDescription(), originalConfiguration.getExtendsFrom(), originalConfiguration.getHierarchy(), originalConfiguration.isVisible(), originalConfiguration.isTransitive(), (TaskDependency)new DefaultTaskDependency());
            Set<String> targetTasks = this.determineTargetTasks(originalConfiguration);
            Set<ComponentArtifactMetadata> artifacts = originalConfiguration.getArtifacts();
            for (ComponentArtifactMetadata originalArtifact : artifacts) {
                File artifactFile = ((LocalComponentArtifactIdentifier)((Object)originalArtifact)).getFile();
                CompositeProjectComponentArtifactMetadata artifact = new CompositeProjectComponentArtifactMetadata(componentIdentifier, originalArtifact.getName(), artifactFile, buildDir, targetTasks);
                compositeComponentMetadata.addArtifact(configurationName, artifact);
            }
        }
        for (DependencyMetadata dependency : originalComponentMetadata.getDependencies()) {
            if (dependency.getSelector() instanceof ProjectComponentSelector) {
                ProjectComponentSelector requested = (ProjectComponentSelector)dependency.getSelector();
                String externalPath = this.createExternalProjectPath(buildName, requested.getProjectPath());
                ProjectComponentSelector externalizedSelector = DefaultProjectComponentSelector.newSelector(externalPath);
                dependency = dependency.withTarget((ComponentSelector)externalizedSelector);
            }
            compositeComponentMetadata.addDependency(dependency);
        }
        for (Exclude exclude : originalComponentMetadata.getExcludeRules()) {
            compositeComponentMetadata.addExclude(exclude);
        }
        return compositeComponentMetadata;
    }

    private String createExternalProjectPath(String buildName, String projectPath) {
        return buildName + ":" + projectPath;
    }

    private ComponentArtifactMetadata createCompositeCopy(ProjectComponentIdentifier project, ComponentArtifactMetadata artifactMetaData, File buildDir) {
        File artifactFile = ((LocalComponentArtifactIdentifier)((Object)artifactMetaData)).getFile();
        return new CompositeProjectComponentArtifactMetadata(project, artifactMetaData.getName(), artifactFile, buildDir, this.getArtifactTasks(artifactMetaData));
    }

    public CompositeBuildContext build() {
        return this.context;
    }

    private Set<String> determineTargetTasks(LocalConfigurationMetadata configuration) {
        LinkedHashSet taskNames = Sets.newLinkedHashSet();
        for (ComponentArtifactMetadata artifactMetaData : configuration.getArtifacts()) {
            this.addArtifactTasks(taskNames, artifactMetaData);
        }
        return taskNames;
    }

    private Set<String> getArtifactTasks(ComponentArtifactMetadata artifactMetaData) {
        LinkedHashSet taskNames = Sets.newLinkedHashSet();
        this.addArtifactTasks(taskNames, artifactMetaData);
        return taskNames;
    }

    private void addArtifactTasks(Set<String> taskNames, ComponentArtifactMetadata artifactMetaData) {
        if (artifactMetaData instanceof Buildable) {
            Buildable publishArtifact = (Buildable)artifactMetaData;
            Set dependencies = publishArtifact.getBuildDependencies().getDependencies(null);
            for (Task dependency : dependencies) {
                taskNames.add(dependency.getPath());
            }
        }
    }
}

