/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeBuildContext;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectArtifactBuilder;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentRegistry;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.LocalComponentArtifactIdentifier;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.service.ServiceRegistry;

public class CompositeBuildIdeProjectResolver {
    private final CompositeBuildContext discovered;
    private final ProjectComponentRegistry registry;
    private final List<ProjectArtifactBuilder> artifactBuilders;

    public CompositeBuildIdeProjectResolver(ServiceRegistry services) {
        List registries = services.getAll(CompositeBuildContext.class);
        this.discovered = !registries.isEmpty() ? (CompositeBuildContext)registries.iterator().next() : null;
        this.registry = (ProjectComponentRegistry)services.get(ProjectComponentRegistry.class);
        this.artifactBuilders = services.getAll(ProjectArtifactBuilder.class);
    }

    public File getProjectDirectory(String projectPath) {
        ProjectComponentIdentifier projectComponentIdentifier = DefaultProjectComponentIdentifier.newId(projectPath);
        return this.getCompositeContext().getProjectDirectory(projectComponentIdentifier);
    }

    public Set<ProjectComponentIdentifier> getProjectsInComposite() {
        if (this.discovered == null) {
            return Collections.emptySet();
        }
        return this.getCompositeContext().getAllProjects();
    }

    private CompositeBuildContext getCompositeContext() {
        if (this.discovered == null) {
            throw new IllegalStateException("Not a composite");
        }
        return this.discovered;
    }

    public ComponentArtifactMetadata resolveArtifact(ProjectComponentIdentifier project, String type) {
        return this.findArtifact(project, type);
    }

    public File resolveArtifactFile(ProjectComponentIdentifier project, String type) {
        ComponentArtifactMetadata artifactMetaData = this.resolveArtifact(project, type);
        if (artifactMetaData == null) {
            throw new IllegalArgumentException("No artifact registered for type: " + type);
        }
        for (ProjectArtifactBuilder artifactBuilder : this.artifactBuilders) {
            artifactBuilder.build(artifactMetaData);
        }
        return ((LocalComponentArtifactIdentifier)((Object)artifactMetaData)).getFile();
    }

    private ComponentArtifactMetadata findArtifact(ProjectComponentIdentifier project, String type) {
        for (ComponentArtifactMetadata artifactMetaData : this.registry.getAdditionalArtifacts(project)) {
            if (!artifactMetaData.getName().getType().equals(type)) continue;
            return artifactMetaData;
        }
        return null;
    }
}

