/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorSerializer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class ModuleDescriptorStore {
    private final PathKeyFileStore metaDataStore;
    private final ModuleDescriptorSerializer moduleDescriptorSerializer;

    public ModuleDescriptorStore(PathKeyFileStore metaDataStore, ModuleDescriptorSerializer moduleDescriptorSerializer) {
        this.metaDataStore = metaDataStore;
        this.moduleDescriptorSerializer = moduleDescriptorSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDescriptorState getModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier moduleComponentIdentifier) {
        String filePath = this.getFilePath(repository, moduleComponentIdentifier);
        LocallyAvailableResource resource = this.metaDataStore.get(filePath);
        if (resource != null) {
            ModuleDescriptorState moduleDescriptorState;
            KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)new FileInputStream(resource.getFile()));
            try {
                moduleDescriptorState = this.moduleDescriptorSerializer.read((Decoder)decoder);
            }
            catch (Throwable throwable) {
                try {
                    decoder.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            decoder.close();
            return moduleDescriptorState;
        }
        return null;
    }

    public LocallyAvailableResource putModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier moduleComponentIdentifier, final ModuleDescriptorState moduleDescriptor) {
        String filePath = this.getFilePath(repository, moduleComponentIdentifier);
        return this.metaDataStore.add(filePath, (Action)new Action<File>(){

            public void execute(File moduleDescriptorFile) {
                try {
                    KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)new FileOutputStream(moduleDescriptorFile));
                    ModuleDescriptorStore.this.moduleDescriptorSerializer.write((Encoder)encoder, moduleDescriptor);
                    encoder.close();
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        });
    }

    private String getFilePath(ModuleComponentRepository repository, ModuleComponentIdentifier moduleComponentIdentifier) {
        return moduleComponentIdentifier.getGroup() + "/" + moduleComponentIdentifier.getModule() + "/" + moduleComponentIdentifier.getVersion() + "/" + repository.getId() + "/descriptor.bin";
    }
}

