/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.descriptor.Dependency;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.descriptor.MutableModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ModuleDescriptorSerializer
implements Serializer<ModuleDescriptorState> {
    public ModuleDescriptorState read(Decoder decoder) throws EOFException, Exception {
        return new Reader(decoder).read();
    }

    public void write(Encoder encoder, ModuleDescriptorState md) throws Exception {
        new Writer(encoder).write(md);
    }

    private static class Reader {
        private final Decoder decoder;
        private MutableModuleDescriptorState md;

        private Reader(Decoder decoder) {
            this.decoder = decoder;
        }

        public ModuleDescriptorState read() throws IOException {
            this.readInfoSection();
            this.readConfigurations();
            this.readArtifacts();
            this.readDependencies();
            this.readAllExcludes();
            return this.md;
        }

        private void readInfoSection() throws IOException {
            ModuleComponentIdentifier componentIdentifier = DefaultModuleComponentIdentifier.newId(this.readString(), this.readString(), this.readString());
            String status = this.readString();
            boolean generated = this.readBoolean();
            this.md = new MutableModuleDescriptorState(componentIdentifier, status, generated);
            this.md.setDescription(this.readNullableString());
            this.md.setPublicationDate(this.readNullableDate());
            this.md.setBranch(this.readNullableString());
            this.readExtraInfo();
        }

        private void readExtraInfo() throws IOException {
            int len = this.readInt();
            for (int i = 0; i < len; ++i) {
                NamespaceId namespaceId = new NamespaceId(this.readString(), this.readString());
                String value = this.readString();
                this.md.getExtraInfo().put(namespaceId, value);
            }
        }

        private void readConfigurations() throws IOException {
            int len = this.readInt();
            for (int i = 0; i < len; ++i) {
                this.readConfiguration();
            }
        }

        private void readConfiguration() throws IOException {
            String name = this.readString();
            boolean transitive = this.readBoolean();
            boolean visible = this.readBoolean();
            List<String> extendsFrom = this.readStringList();
            this.md.addConfiguration(name, transitive, visible, extendsFrom);
        }

        private void readArtifacts() throws IOException {
            int size = this.readInt();
            for (int i = 0; i < size; ++i) {
                DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.readString(), this.readString(), this.readNullableString(), this.readNullableString());
                this.md.addArtifact(ivyArtifactName, this.readStringSet());
            }
        }

        private void readDependencies() throws IOException {
            int len = this.readInt();
            for (int i = 0; i < len; ++i) {
                this.readDependency();
            }
        }

        private void readDependency() throws IOException {
            ModuleVersionSelector requested = DefaultModuleVersionSelector.newSelector(this.readString(), this.readString(), this.readString());
            Dependency dep = this.md.addDependency(requested, this.readString(), this.readBoolean(), this.readBoolean(), this.readBoolean());
            this.readDependencyConfigurationMapping(dep);
            this.readDependencyArtifactDescriptors(dep);
            this.readExcludeRules(dep);
        }

        private void readDependencyConfigurationMapping(Dependency dep) throws IOException {
            int size = this.readInt();
            for (int i = 0; i < size; ++i) {
                String from = this.readString();
                List<String> to = this.readStringList();
                dep.addDependencyConfiguration(from, to);
            }
        }

        private void readDependencyArtifactDescriptors(Dependency dep) throws IOException {
            int size = this.readInt();
            for (int i = 0; i < size; ++i) {
                DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.readString(), this.readString(), this.readNullableString(), this.readNullableString());
                dep.addArtifact(ivyArtifactName, this.readStringSet());
            }
        }

        private void readExcludeRules(Dependency dep) throws IOException {
            int len = this.readInt();
            for (int i = 0; i < len; ++i) {
                DefaultExclude rule = this.readExcludeRule();
                dep.addExcludeRule(rule);
            }
        }

        private DefaultExclude readExcludeRule() throws IOException {
            String moduleOrg = this.readString();
            String moduleName = this.readString();
            String artifact = this.readString();
            String type = this.readString();
            String ext = this.readString();
            String[] confs = this.readStringArray();
            String matcher = this.readString();
            return new DefaultExclude(moduleOrg, moduleName, artifact, type, ext, confs, matcher);
        }

        private void readAllExcludes() throws IOException {
            int len = this.readInt();
            for (int i = 0; i < len; ++i) {
                this.md.addExclude(this.readExcludeRule());
            }
        }

        private int readInt() throws IOException {
            return this.decoder.readInt();
        }

        private String readString() throws IOException {
            return this.decoder.readString();
        }

        private String readNullableString() throws IOException {
            return this.decoder.readNullableString();
        }

        private boolean readBoolean() throws IOException {
            return this.decoder.readBoolean();
        }

        private Date readNullableDate() throws IOException {
            long value = this.readLong();
            if (value == -1L) {
                return null;
            }
            return new Date(value);
        }

        private long readLong() throws IOException {
            return this.decoder.readLong();
        }

        private String[] readStringArray() throws IOException {
            int size = this.readInt();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.readString();
            }
            return array;
        }

        private List<String> readStringList() throws IOException {
            int size = this.readInt();
            ArrayList<String> list = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.readString());
            }
            return list;
        }

        private Set<String> readStringSet() throws IOException {
            int size = this.readInt();
            LinkedHashSet<String> set = new LinkedHashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                set.add(this.readString());
            }
            return set;
        }
    }

    private static class Writer {
        private final Encoder encoder;

        private Writer(Encoder encoder) {
            this.encoder = encoder;
        }

        public void write(ModuleDescriptorState md) throws IOException {
            this.writeInfoSection(md);
            this.writeConfigurations(md.getConfigurations());
            this.writeArtifacts(md.getArtifacts());
            this.writeDependencies(md.getDependencies());
            this.writeExcludeRules(md.getExcludes());
        }

        private void writeInfoSection(ModuleDescriptorState md) throws IOException {
            ModuleComponentIdentifier componentIdentifier = md.getComponentIdentifier();
            this.writeString(componentIdentifier.getGroup());
            this.writeString(componentIdentifier.getModule());
            this.writeString(componentIdentifier.getVersion());
            this.writeString(md.getStatus());
            this.writeBoolean(md.isGenerated());
            this.writeNullableString(md.getDescription());
            this.writeNullableDate(md.getPublicationDate());
            this.writeNullableString(md.getBranch());
            this.writeExtraInfo(md.getExtraInfo());
        }

        private void writeExtraInfo(Map<NamespaceId, String> extraInfo) throws IOException {
            this.writeInt(extraInfo.size());
            for (Map.Entry<NamespaceId, String> entry : extraInfo.entrySet()) {
                NamespaceId namespaceId = entry.getKey();
                this.writeString(namespaceId.getNamespace());
                this.writeString(namespaceId.getName());
                this.writeString(entry.getValue());
            }
        }

        private void writeConfigurations(Collection<Configuration> configurations) throws IOException {
            this.writeInt(configurations.size());
            for (Configuration conf : configurations) {
                this.writeConfiguration(conf);
            }
        }

        private void writeConfiguration(Configuration conf) throws IOException {
            this.writeString(conf.getName());
            this.writeBoolean(conf.isTransitive());
            this.writeBoolean(conf.isVisible());
            this.writeStringList(conf.getExtendsFrom());
        }

        private void writeArtifacts(List<Artifact> artifacts) throws IOException {
            this.writeInt(artifacts.size());
            for (Artifact artifact : artifacts) {
                IvyArtifactName artifactName = artifact.getArtifactName();
                this.writeString(artifactName.getName());
                this.writeString(artifactName.getType());
                this.writeNullableString(artifactName.getExtension());
                this.writeNullableString(artifactName.getClassifier());
                this.writeStringSet(artifact.getConfigurations());
            }
        }

        private void writeDependencies(List<Dependency> dependencies) throws IOException {
            this.writeInt(dependencies.size());
            for (Dependency dd : dependencies) {
                this.writeDependency(dd);
            }
        }

        private void writeDependency(Dependency dep) throws IOException {
            ModuleVersionSelector selector = dep.getRequested();
            this.writeString(selector.getGroup());
            this.writeString(selector.getName());
            this.writeString(selector.getVersion());
            this.writeString(dep.getDynamicConstraintVersion());
            this.writeBoolean(dep.isForce());
            this.writeBoolean(dep.isChanging());
            this.writeBoolean(dep.isTransitive());
            this.writeDependencyConfigurationMapping(dep);
            this.writeArtifacts(dep.getDependencyArtifacts());
            this.writeExcludeRules(dep.getDependencyExcludes());
        }

        private void writeDependencyConfigurationMapping(Dependency dep) throws IOException {
            Map<String, List<String>> confMappings = dep.getConfMappings();
            this.writeInt(confMappings.size());
            for (Map.Entry<String, List<String>> entry : confMappings.entrySet()) {
                this.writeString(entry.getKey());
                this.writeStringList(entry.getValue());
            }
        }

        private void writeExcludeRules(List<Exclude> excludes) throws IOException {
            this.writeInt(excludes.size());
            for (Exclude exclude : excludes) {
                IvyArtifactName artifact = exclude.getArtifact();
                this.writeString(exclude.getModuleId().getGroup());
                this.writeString(exclude.getModuleId().getName());
                this.writeString(artifact.getName());
                this.writeString(artifact.getType());
                this.writeString(artifact.getExtension());
                this.writeStringArray(exclude.getConfigurations());
                this.writeString(exclude.getMatcher());
            }
        }

        private void writeInt(int i) throws IOException {
            this.encoder.writeInt(i);
        }

        private void writeString(String str) throws IOException {
            this.encoder.writeString((CharSequence)str);
        }

        private void writeNullableString(String str) throws IOException {
            this.encoder.writeNullableString((CharSequence)str);
        }

        private void writeBoolean(boolean b) throws IOException {
            this.encoder.writeBoolean(b);
        }

        private void writeNullableDate(Date publicationDate) throws IOException {
            if (publicationDate == null) {
                this.writeLong(-1L);
            } else {
                this.writeLong(publicationDate.getTime());
            }
        }

        private void writeLong(long l) throws IOException {
            this.encoder.writeLong(l);
        }

        private void writeStringArray(String[] values) throws IOException {
            this.writeInt(values.length);
            for (String configuration : values) {
                this.writeNullableString(configuration);
            }
        }

        private void writeStringList(List<String> values) throws IOException {
            this.writeInt(values.size());
            for (String configuration : values) {
                this.writeString(configuration);
            }
        }

        private void writeStringSet(Set<String> values) throws IOException {
            this.writeInt(values.size());
            for (String configuration : values) {
                this.writeString(configuration);
            }
        }
    }
}

