/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.DefaultCachedMetaData;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorCacheEntrySerializer;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorStore;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetaDataCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.BuildCommencedTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleMetaDataCache
implements ModuleMetaDataCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModuleMetaDataCache.class);
    private final BuildCommencedTimeProvider timeProvider;
    private final CacheLockingManager cacheLockingManager;
    private final ModuleDescriptorStore moduleDescriptorStore;
    private PersistentIndexedCache<RevisionKey, ModuleDescriptorCacheEntry> cache;

    public DefaultModuleMetaDataCache(BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager) {
        this.timeProvider = timeProvider;
        this.cacheLockingManager = cacheLockingManager;
        this.moduleDescriptorStore = new ModuleDescriptorStore(new PathKeyFileStore(cacheLockingManager.createMetaDataStore()), new ModuleDescriptorSerializer());
    }

    private PersistentIndexedCache<RevisionKey, ModuleDescriptorCacheEntry> getCache() {
        if (this.cache == null) {
            this.cache = this.initCache();
        }
        return this.cache;
    }

    private PersistentIndexedCache<RevisionKey, ModuleDescriptorCacheEntry> initCache() {
        return this.cacheLockingManager.createCache("module-metadata", new RevisionKeySerializer(), new ModuleDescriptorCacheEntrySerializer());
    }

    @Override
    public ModuleMetaDataCache.CachedMetaData getCachedModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier componentId) {
        ModuleDescriptorCacheEntry entry = (ModuleDescriptorCacheEntry)this.getCache().get((Object)this.createKey(repository, componentId));
        if (entry == null) {
            return null;
        }
        if (entry.isMissing()) {
            return new DefaultCachedMetaData(entry, null, this.timeProvider);
        }
        ModuleDescriptorState descriptor = this.moduleDescriptorStore.getModuleDescriptor(repository, componentId);
        if (descriptor == null) {
            return null;
        }
        return new DefaultCachedMetaData(entry, entry.createMetaData(componentId, descriptor), this.timeProvider);
    }

    @Override
    public ModuleMetaDataCache.CachedMetaData cacheMissing(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        LOGGER.debug("Recording absence of module descriptor in cache: {} [changing = {}]", (Object)id, (Object)false);
        ModuleDescriptorCacheEntry entry = ModuleDescriptorCacheEntry.forMissingModule(this.timeProvider.getCurrentTime());
        this.getCache().put((Object)this.createKey(repository, id), (Object)entry);
        return new DefaultCachedMetaData(entry, null, this.timeProvider);
    }

    @Override
    public ModuleMetaDataCache.CachedMetaData cacheMetaData(ModuleComponentRepository repository, ModuleComponentResolveMetadata metaData) {
        ModuleDescriptorState moduleDescriptor = metaData.getDescriptor();
        LOGGER.debug("Recording module descriptor in cache: {} [changing = {}]", (Object)moduleDescriptor.getComponentIdentifier(), (Object)metaData.isChanging());
        LocallyAvailableResource resource = this.moduleDescriptorStore.putModuleDescriptor(repository, metaData.getComponentId(), moduleDescriptor);
        ModuleDescriptorCacheEntry entry = this.createEntry(metaData, resource.getSha1());
        this.getCache().put((Object)this.createKey(repository, metaData.getComponentId()), (Object)entry);
        return new DefaultCachedMetaData(entry, null, this.timeProvider);
    }

    private RevisionKey createKey(ModuleComponentRepository repository, ModuleComponentIdentifier id) {
        return new RevisionKey(repository.getId(), id);
    }

    private ModuleDescriptorCacheEntry createEntry(ModuleComponentResolveMetadata metaData, HashValue moduleDescriptorHash) {
        return ModuleDescriptorCacheEntry.forMetaData(metaData, this.timeProvider.getCurrentTime(), moduleDescriptorHash.asBigInteger());
    }

    private static class RevisionKeySerializer
    implements Serializer<RevisionKey> {
        private final ComponentIdentifierSerializer componentIdSerializer = new ComponentIdentifierSerializer();

        private RevisionKeySerializer() {
        }

        public void write(Encoder encoder, RevisionKey value) throws Exception {
            encoder.writeString((CharSequence)value.repositoryId);
            this.componentIdSerializer.write(encoder, (ComponentIdentifier)value.componentId);
        }

        public RevisionKey read(Decoder decoder) throws Exception {
            String resolverId = decoder.readString();
            ModuleComponentIdentifier identifier = (ModuleComponentIdentifier)this.componentIdSerializer.read(decoder);
            return new RevisionKey(resolverId, identifier);
        }
    }

    private static class RevisionKey {
        private final String repositoryId;
        private final ModuleComponentIdentifier componentId;

        private RevisionKey(String repositoryId, ModuleComponentIdentifier componentId) {
            this.repositoryId = repositoryId;
            this.componentId = componentId;
        }

        public String toString() {
            return this.repositoryId + "," + this.componentId;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RevisionKey)) {
                return false;
            }
            RevisionKey other = (RevisionKey)o;
            return this.repositoryId.equals(other.repositoryId) && this.componentId.equals(other.componentId);
        }

        public int hashCode() {
            return this.repositoryId.hashCode() ^ this.componentId.hashCode();
        }
    }
}

