/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.math.BigInteger;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetaDataCache;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.util.BuildCommencedTimeProvider;

class DefaultCachedMetaData
implements ModuleMetaDataCache.CachedMetaData {
    private final ModuleSource moduleSource;
    private final BigInteger descriptorHash;
    private final long ageMillis;
    private final MutableModuleComponentResolveMetadata metaData;

    public DefaultCachedMetaData(ModuleDescriptorCacheEntry entry, MutableModuleComponentResolveMetadata metaData, BuildCommencedTimeProvider timeProvider) {
        this.moduleSource = entry.moduleSource;
        this.descriptorHash = entry.moduleDescriptorHash;
        this.ageMillis = timeProvider.getCurrentTime() - entry.createTimestamp;
        this.metaData = metaData;
    }

    @Override
    public boolean isMissing() {
        return this.metaData == null;
    }

    @Override
    public ModuleSource getModuleSource() {
        return this.moduleSource;
    }

    @Override
    public ResolvedModuleVersion getModuleVersion() {
        return this.isMissing() ? null : new DefaultResolvedModuleVersion(this.getMetaData().getId());
    }

    @Override
    public MutableModuleComponentResolveMetadata getMetaData() {
        return this.metaData;
    }

    @Override
    public long getAgeMillis() {
        return this.ageMillis;
    }

    @Override
    public BigInteger getDescriptorHash() {
        return this.descriptorHash;
    }
}

