/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomReader;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.UnresolvedDependencyVersionException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomDependencyMgt;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.descriptor.Dependency;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.descriptor.MutableModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;

public class GradlePomModuleDescriptorBuilder {
    public static final Configuration[] MAVEN2_CONFIGURATIONS = new Configuration[]{new Configuration("default", Configuration.Visibility.PUBLIC, "runtime dependencies and master artifact can be used with this conf", new String[]{"runtime", "master"}, true, null), new Configuration("master", Configuration.Visibility.PUBLIC, "contains only the artifact published by this module itself, with no transitive dependencies", new String[0], true, null), new Configuration("compile", Configuration.Visibility.PUBLIC, "this is the default scope, used if none is specified. Compile dependencies are available in all classpaths.", new String[0], true, null), new Configuration("provided", Configuration.Visibility.PUBLIC, "this is much like compile, but indicates you expect the JDK or a container to provide it. It is only available on the compilation classpath, and is not transitive.", new String[0], true, null), new Configuration("runtime", Configuration.Visibility.PUBLIC, "this scope indicates that the dependency is not required for compilation, but is for execution. It is in the runtime and test classpaths, but not the compile classpath.", new String[]{"compile"}, true, null), new Configuration("test", Configuration.Visibility.PRIVATE, "this scope indicates that the dependency is not required for normal use of the application, and is only available for the test compilation and execution phases.", new String[]{"runtime"}, true, null), new Configuration("system", Configuration.Visibility.PUBLIC, "this scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact is always available and is not looked up in a repository.", new String[0], true, null), new Configuration("sources", Configuration.Visibility.PUBLIC, "this configuration contains the source artifact of this module, if any.", new String[0], true, null), new Configuration("javadoc", Configuration.Visibility.PUBLIC, "this configuration contains the javadoc artifact of this module, if any.", new String[0], true, null), new Configuration("optional", Configuration.Visibility.PUBLIC, "contains all optional dependencies", new String[0], true, null)};
    static final Map<String, ConfMapper> MAVEN2_CONF_MAPPING = new HashMap<String, ConfMapper>();
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("(.+)-\\d{8}\\.\\d{6}-\\d+");
    private static final String EXTRA_ATTRIBUTE_CLASSIFIER = "m:classifier";
    private final VersionSelectorScheme defaultVersionSelectorScheme;
    private final VersionSelectorScheme mavenVersionSelectorScheme;
    private MutableModuleDescriptorState descriptor;
    private final PomReader pomReader;

    public GradlePomModuleDescriptorBuilder(PomReader pomReader, VersionSelectorScheme gradleVersionSelectorScheme, VersionSelectorScheme mavenVersionSelectorScheme) {
        this.defaultVersionSelectorScheme = gradleVersionSelectorScheme;
        this.mavenVersionSelectorScheme = mavenVersionSelectorScheme;
        this.pomReader = pomReader;
    }

    public ModuleDescriptorState getModuleDescriptor() {
        return this.descriptor;
    }

    public void setModuleRevId(String group, String module, String version) {
        Matcher matcher;
        String effectiveVersion = version;
        if (version != null && (matcher = TIMESTAMP_PATTERN.matcher(version)).matches()) {
            effectiveVersion = matcher.group(1) + "-SNAPSHOT";
        }
        String status = effectiveVersion != null && effectiveVersion.endsWith("SNAPSHOT") ? "integration" : "release";
        this.descriptor = new MutableModuleDescriptorState(DefaultModuleComponentIdentifier.newId(group, module, effectiveVersion), status, false);
        for (Configuration maven2Configuration : MAVEN2_CONFIGURATIONS) {
            this.descriptor.addConfiguration(maven2Configuration.getName(), maven2Configuration.isTransitive(), maven2Configuration.getVisibility() == Configuration.Visibility.PUBLIC, Lists.newArrayList((Object[])maven2Configuration.getExtends()));
        }
    }

    public void setDescription(String description) {
        this.descriptor.setDescription(description);
    }

    public void addDependency(PomReader.PomDependencyData dep) {
        List<ModuleIdentifier> excluded;
        boolean hasNonJarType;
        String scope = dep.getScope();
        if (scope != null && scope.length() > 0 && !MAVEN2_CONF_MAPPING.containsKey(scope)) {
            scope = "compile";
        }
        String version = this.determineVersion(dep);
        String mappedVersion = this.convertVersionFromMavenSyntax(version);
        ModuleVersionSelector selector = DefaultModuleVersionSelector.newSelector(dep.getGroupId(), dep.getArtifactId(), mappedVersion);
        if (selector.getGroup().equals(this.descriptor.getComponentIdentifier().getGroup()) && selector.getName().equals(this.descriptor.getComponentIdentifier().getModule())) {
            return;
        }
        Dependency dependency = this.descriptor.addDependency(selector);
        scope = scope == null || scope.length() == 0 ? this.getDefaultScope(dep) : scope;
        ConfMapper mapping = MAVEN2_CONF_MAPPING.get(scope);
        mapping.addMappingConfs(dependency, dep.isOptional());
        boolean hasClassifier = dep.getClassifier() != null && dep.getClassifier().length() > 0;
        boolean bl = hasNonJarType = dep.getType() != null && !"jar".equals(dep.getType());
        if (hasClassifier || hasNonJarType) {
            String type = "jar";
            if (dep.getType() != null) {
                type = dep.getType();
            }
            String ext = this.determineExtension(type);
            String classifier = hasClassifier ? dep.getClassifier() : this.getClassifierForType(type);
            String optionalizedScope = dep.isOptional() ? "optional" : scope;
            DefaultIvyArtifactName artifactName = new DefaultIvyArtifactName(selector.getName(), type, ext, classifier);
            dependency.addArtifact(artifactName, Collections.singleton(optionalizedScope));
        }
        if ((excluded = dep.getExcludedModules()).isEmpty()) {
            excluded = this.getDependencyMgtExclusions(dep);
        }
        Set<String> confs = dependency.getConfMappings().keySet();
        String[] confArray = confs.toArray(new String[confs.size()]);
        for (ModuleIdentifier excludedModule : excluded) {
            DefaultExclude rule = new DefaultExclude(excludedModule.getGroup(), excludedModule.getName(), confArray, "exact");
            dependency.addExcludeRule(rule);
        }
    }

    private String convertVersionFromMavenSyntax(String version) {
        VersionSelector versionSelector = this.mavenVersionSelectorScheme.parseSelector(version);
        return this.defaultVersionSelectorScheme.renderSelector(versionSelector);
    }

    private String determineExtension(String type) {
        return JarDependencyType.isJarExtension(type) ? "jar" : type;
    }

    private String getClassifierForType(String type) {
        if (JarDependencyType.TEST_JAR.getName().equals(type)) {
            return "tests";
        }
        if (JarDependencyType.EJB_CLIENT.getName().equals(type)) {
            return "client";
        }
        return null;
    }

    private String determineVersion(PomReader.PomDependencyData dependency) {
        String version = dependency.getVersion();
        String string = version = version == null || version.length() == 0 ? this.getDefaultVersion(dependency) : version;
        if (version == null) {
            throw new UnresolvedDependencyVersionException(dependency.getId());
        }
        return version;
    }

    public void addDependencyForRelocation(ModuleVersionSelector selector) {
        Configuration[] m2Confs;
        if (selector.getGroup().equals(this.descriptor.getComponentIdentifier().getGroup()) && selector.getName().equals(this.descriptor.getComponentIdentifier().getModule())) {
            return;
        }
        Dependency dependency = this.descriptor.addDependency(selector);
        for (Configuration m2Conf : m2Confs = MAVEN2_CONFIGURATIONS) {
            if (!Configuration.Visibility.PUBLIC.equals(m2Conf.getVisibility())) continue;
            dependency.addDependencyConfiguration(m2Conf.getName(), m2Conf.getName());
        }
    }

    private String getDefaultVersion(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        if (pomDependencyMgt != null) {
            return pomDependencyMgt.getVersion();
        }
        return null;
    }

    private String getDefaultScope(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        String result = null;
        if (pomDependencyMgt != null) {
            result = pomDependencyMgt.getScope();
        }
        if (result == null || !MAVEN2_CONF_MAPPING.containsKey(result)) {
            result = "compile";
        }
        return result;
    }

    private List<ModuleIdentifier> getDependencyMgtExclusions(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        if (pomDependencyMgt != null) {
            return pomDependencyMgt.getExcludedModules();
        }
        return Collections.emptyList();
    }

    private PomDependencyMgt findDependencyDefault(PomReader.PomDependencyData dependency) {
        return this.pomReader.findDependencyDefaults(dependency.getId());
    }

    static {
        MAVEN2_CONF_MAPPING.put("compile", new ConfMapper(){

            @Override
            public void addMappingConfs(Dependency dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("compile", "compile(*)");
                    dd.addDependencyConfiguration("compile", "master(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("provided", new ConfMapper(){

            @Override
            public void addMappingConfs(Dependency dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "runtime(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("provided", "compile(*)");
                    dd.addDependencyConfiguration("provided", "provided(*)");
                    dd.addDependencyConfiguration("provided", "runtime(*)");
                    dd.addDependencyConfiguration("provided", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("runtime", new ConfMapper(){

            @Override
            public void addMappingConfs(Dependency dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("runtime", "compile(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                    dd.addDependencyConfiguration("runtime", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("test", new ConfMapper(){

            @Override
            public void addMappingConfs(Dependency dd, boolean isOptional) {
                dd.addDependencyConfiguration("test", "runtime(*)");
                dd.addDependencyConfiguration("test", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("system", new ConfMapper(){

            @Override
            public void addMappingConfs(Dependency dd, boolean isOptional) {
                dd.addDependencyConfiguration("system", "master(*)");
            }
        });
    }

    private static enum JarDependencyType {
        TEST_JAR("test-jar"),
        EJB_CLIENT("ejb-client"),
        EJB("ejb"),
        BUNDLE("bundle"),
        MAVEN_PLUGIN("maven-plugin"),
        ECLIPSE_PLUGIN("eclipse-plugin");

        private static final Map<String, JarDependencyType> TYPES;
        private final String name;

        private JarDependencyType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static boolean isJarExtension(String type) {
            return TYPES.containsKey(type);
        }

        static {
            TYPES = new HashMap<String, JarDependencyType>();
            for (JarDependencyType type : JarDependencyType.values()) {
                TYPES.put(type.name, type);
            }
        }
    }

    static interface ConfMapper {
        public void addMappingConfs(Dependency var1, boolean var2);
    }
}

