/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentSelectionResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicVersionResolver
implements DependencyToComponentIdResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVersionResolver.class);
    private final List<ModuleComponentRepository> repositories = new ArrayList<ModuleComponentRepository>();
    private final List<String> repositoryNames = new ArrayList<String>();
    private final VersionedComponentChooser versionedComponentChooser;
    private final Transformer<ModuleComponentResolveMetadata, RepositoryChainModuleResolution> metaDataFactory;

    public DynamicVersionResolver(VersionedComponentChooser versionedComponentChooser, Transformer<ModuleComponentResolveMetadata, RepositoryChainModuleResolution> metaDataFactory) {
        this.versionedComponentChooser = versionedComponentChooser;
        this.metaDataFactory = metaDataFactory;
    }

    public void add(ModuleComponentRepository repository) {
        this.repositories.add(repository);
        this.repositoryNames.add(repository.getName());
    }

    @Override
    public void resolve(DependencyMetadata dependency, BuildableComponentIdResolveResult result) {
        ModuleVersionSelector requested = dependency.getRequested();
        LOGGER.debug("Attempting to resolve version for {} using repositories {}", (Object)requested, this.repositoryNames);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ArrayList<RepositoryResolveState> resolveStates = new ArrayList<RepositoryResolveState>();
        for (ModuleComponentRepository repository : this.repositories) {
            resolveStates.add(new RepositoryResolveState(dependency, repository));
        }
        RepositoryChainModuleResolution latestResolved = this.findLatestModule(resolveStates, errors);
        if (latestResolved != null) {
            LOGGER.debug("Using {} from {}", (Object)latestResolved.module.getId(), (Object)latestResolved.repository);
            for (Throwable error : errors) {
                LOGGER.debug("Discarding resolve failure.", error);
            }
            result.resolved((ComponentResolveMetadata)this.metaDataFactory.transform((Object)latestResolved));
            return;
        }
        if (!errors.isEmpty()) {
            result.failed(new ModuleVersionResolveException(requested, errors));
        } else {
            this.notFound(result, requested, resolveStates);
        }
    }

    private void notFound(BuildableComponentIdResolveResult result, ModuleVersionSelector requested, List<RepositoryResolveState> resolveStates) {
        LinkedHashSet<String> unmatchedVersions = new LinkedHashSet<String>();
        LinkedHashSet<String> rejectedVersions = new LinkedHashSet<String>();
        for (RepositoryResolveState resolveState : resolveStates) {
            resolveState.applyTo(result, unmatchedVersions, rejectedVersions);
        }
        result.failed(new ModuleVersionNotFoundException(requested, result.getAttempted(), unmatchedVersions, rejectedVersions));
    }

    private RepositoryChainModuleResolution findLatestModule(List<RepositoryResolveState> resolveStates, Collection<Throwable> failures) {
        LinkedList<RepositoryResolveState> queue = new LinkedList<RepositoryResolveState>();
        queue.addAll(resolveStates);
        LinkedList<RepositoryResolveState> missing = new LinkedList<RepositoryResolveState>();
        RepositoryChainModuleResolution best = this.findLatestModule(queue, failures, missing);
        if (best != null) {
            return best;
        }
        queue.addAll(missing);
        missing.clear();
        return this.findLatestModule(queue, failures, missing);
    }

    private RepositoryChainModuleResolution findLatestModule(LinkedList<RepositoryResolveState> queue, Collection<Throwable> failures, Collection<RepositoryResolveState> missing) {
        RepositoryChainModuleResolution best = null;
        block7: while (!queue.isEmpty()) {
            RepositoryResolveState request = queue.removeFirst();
            try {
                request.resolve();
            }
            catch (Throwable t) {
                failures.add(t);
                continue;
            }
            switch (request.resolveResult.getState()) {
                case Failed: {
                    failures.add((Throwable)((Object)request.resolveResult.getFailure()));
                    continue block7;
                }
                case Missing: 
                case Unknown: {
                    if (!request.canMakeFurtherAttempts()) continue block7;
                    missing.add(request);
                    continue block7;
                }
                case Resolved: {
                    RepositoryChainModuleResolution moduleResolution = new RepositoryChainModuleResolution(request.repository, request.resolveResult.getMetaData());
                    best = this.chooseBest(best, moduleResolution);
                    continue block7;
                }
            }
            throw new IllegalStateException("Unexpected state for resolution: " + (Object)((Object)request.resolveResult.getState()));
        }
        return best;
    }

    private RepositoryChainModuleResolution chooseBest(RepositoryChainModuleResolution one, RepositoryChainModuleResolution two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        return this.versionedComponentChooser.selectNewestComponent(one.module, two.module) == one.module ? one : two;
    }

    private static class VersionListResult {
        private final DefaultBuildableModuleVersionListingResolveResult result = new DefaultBuildableModuleVersionListingResolveResult();
        private final ModuleComponentRepository repository;
        private final DependencyMetadata dependency;
        private boolean searchedLocally;
        private boolean searchedRemotely;

        public VersionListResult(DependencyMetadata dependency, ModuleComponentRepository repository) {
            this.dependency = dependency;
            this.repository = repository;
        }

        void resolve() {
            if (!this.searchedLocally) {
                this.searchedLocally = true;
                this.process(this.dependency, this.repository.getLocalAccess());
                if (this.result.hasResult()) {
                    if (this.result.isAuthoritative()) {
                        this.searchedRemotely = true;
                    }
                    return;
                }
            }
            if (!this.searchedRemotely) {
                this.searchedRemotely = true;
                this.process(this.dependency, this.repository.getRemoteAccess());
            }
        }

        public boolean canMakeFurtherAttempts() {
            return !this.searchedRemotely;
        }

        public void applyTo(ResourceAwareResolveResult target) {
            this.result.applyTo(target);
        }

        private void process(DependencyMetadata dynamicVersionDependency, ModuleComponentRepositoryAccess moduleAccess) {
            moduleAccess.listModuleVersions(dynamicVersionDependency, this.result);
        }
    }

    private static class CandidateResult
    implements ModuleComponentResolveState {
        private final ModuleComponentIdentifier identifier;
        private final ModuleComponentRepository repository;
        private final AttemptCollector attemptCollector;
        private final DependencyMetadata dependencyMetadata;
        private final String version;
        private boolean searchedLocally;
        private boolean searchedRemotely;
        private final DefaultBuildableModuleComponentMetaDataResolveResult result = new DefaultBuildableModuleComponentMetaDataResolveResult();

        public CandidateResult(DependencyMetadata dependencyMetadata, String version, ModuleComponentRepository repository, AttemptCollector attemptCollector) {
            this.dependencyMetadata = dependencyMetadata;
            this.version = version;
            this.repository = repository;
            this.attemptCollector = attemptCollector;
            ModuleVersionSelector requested = dependencyMetadata.getRequested();
            this.identifier = DefaultModuleComponentIdentifier.newId(requested.getGroup(), requested.getName(), version);
        }

        @Override
        public ModuleComponentIdentifier getId() {
            return this.identifier;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public BuildableModuleComponentMetaDataResolveResult resolve() {
            if (!this.searchedLocally) {
                this.searchedLocally = true;
                this.process(this.repository.getLocalAccess());
                if (this.result.hasResult() && this.result.isAuthoritative()) {
                    this.searchedRemotely = true;
                }
            }
            if (this.result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved || this.result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
                return this.result;
            }
            if (!this.searchedRemotely) {
                this.searchedRemotely = true;
                this.process(this.repository.getRemoteAccess());
            }
            return this.result;
        }

        private void process(ModuleComponentRepositoryAccess access) {
            DependencyMetadata dependency = this.dependencyMetadata.withRequestedVersion(this.version);
            access.resolveComponentMetaData(this.identifier, DefaultComponentOverrideMetadata.forDependency(dependency), this.result);
            this.attemptCollector.execute(this.result);
        }

        public void resolve(DefaultBuildableModuleComponentMetaDataResolveResult target) {
            this.resolve();
            switch (this.result.getState()) {
                case Resolved: {
                    target.resolved(this.result.getMetaData());
                    break;
                }
                case Missing: {
                    this.result.applyTo(target);
                    target.missing();
                    break;
                }
                case Failed: {
                    target.failed(this.result.getFailure());
                    break;
                }
                case Unknown: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private class RepositoryResolveState {
        private final DefaultBuildableModuleComponentMetaDataResolveResult resolveResult = new DefaultBuildableModuleComponentMetaDataResolveResult();
        private final DefaultBuildableComponentSelectionResult componentSelectionResult = new DefaultBuildableComponentSelectionResult();
        private final Map<String, CandidateResult> candidateComponents = new LinkedHashMap<String, CandidateResult>();
        private final VersionListResult versionListingResult;
        private final ModuleComponentRepository repository;
        private final AttemptCollector attemptCollector;
        private final DependencyMetadata dependency;
        private final ModuleVersionSelector selector;

        public RepositoryResolveState(DependencyMetadata dependency, ModuleComponentRepository repository) {
            this.dependency = dependency;
            this.selector = dependency.getRequested();
            this.repository = repository;
            this.attemptCollector = new AttemptCollector();
            this.versionListingResult = new VersionListResult(dependency, repository);
        }

        public boolean canMakeFurtherAttempts() {
            return this.versionListingResult.canMakeFurtherAttempts();
        }

        void resolve() {
            this.versionListingResult.resolve();
            switch (this.versionListingResult.result.getState()) {
                case Failed: {
                    this.resolveResult.failed(this.versionListingResult.result.getFailure());
                    break;
                }
                case Listed: {
                    this.selectMatchingVersionAndResolve();
                    break;
                }
                case Unknown: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state for version list result.");
                }
            }
        }

        private void selectMatchingVersionAndResolve() {
            DynamicVersionResolver.this.versionedComponentChooser.selectNewestMatchingComponent(this.candidates(), this.componentSelectionResult, this.selector);
            switch (this.componentSelectionResult.getState()) {
                case NoMatch: {
                    this.resolveResult.missing();
                    break;
                }
                case Match: {
                    ModuleComponentIdentifier selectedComponentId = this.componentSelectionResult.getMatch();
                    CandidateResult candidateResult = this.candidateComponents.get(selectedComponentId.getVersion());
                    candidateResult.resolve(this.resolveResult);
                    break;
                }
                case Failed: {
                    this.resolveResult.failed(this.componentSelectionResult.getFailure());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state for component selection result.");
                }
            }
        }

        private List<CandidateResult> candidates() {
            ArrayList<CandidateResult> candidates = new ArrayList<CandidateResult>();
            for (String version : this.versionListingResult.result.getVersions()) {
                CandidateResult candidateResult = this.candidateComponents.get(version);
                if (candidateResult == null) {
                    candidateResult = new CandidateResult(this.dependency, version, this.repository, this.attemptCollector);
                    this.candidateComponents.put(version, candidateResult);
                }
                candidates.add(candidateResult);
            }
            return candidates;
        }

        protected void applyTo(ResourceAwareResolveResult target, Set<String> unmatchedVersions, Set<String> rejectedVersions) {
            this.versionListingResult.applyTo(target);
            this.attemptCollector.applyTo(target);
            unmatchedVersions.addAll(this.componentSelectionResult.getUnmatchedVersions());
            rejectedVersions.addAll(this.componentSelectionResult.getRejectedVersions());
        }
    }

    private static class AttemptCollector
    implements Action<ResourceAwareResolveResult> {
        private final List<String> attempts = new ArrayList<String>();

        private AttemptCollector() {
        }

        public void execute(ResourceAwareResolveResult resourceAwareResolveResult) {
            this.attempts.addAll(resourceAwareResolveResult.getAttempted());
        }

        public void applyTo(ResourceAwareResolveResult result) {
            for (String url : this.attempts) {
                result.attempted(url);
            }
        }
    }
}

