/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentUsage;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

public class CacheLockingArtifactResolver
implements ArtifactResolver {
    private final CacheLockingManager lockingManager;
    private final ArtifactResolver delegate;

    public CacheLockingArtifactResolver(CacheLockingManager lockingManager, ArtifactResolver delegate) {
        this.lockingManager = lockingManager;
        this.delegate = delegate;
    }

    @Override
    public void resolveModuleArtifacts(final ComponentResolveMetadata component, final ArtifactType artifactType, final BuildableArtifactSetResolveResult result) {
        String description = "Resolve " + artifactType + " for " + component;
        this.lockingManager.useCache(description, new Runnable(){

            @Override
            public void run() {
                CacheLockingArtifactResolver.this.delegate.resolveModuleArtifacts(component, artifactType, result);
            }
        });
    }

    @Override
    public void resolveModuleArtifacts(final ComponentResolveMetadata component, final ComponentUsage usage, final BuildableArtifactSetResolveResult result) {
        String description = "Resolve " + usage + " for " + component;
        this.lockingManager.useCache(description, new Runnable(){

            @Override
            public void run() {
                CacheLockingArtifactResolver.this.delegate.resolveModuleArtifacts(component, usage, result);
            }
        });
    }

    @Override
    public void resolveArtifact(final ComponentArtifactMetadata artifact, final ModuleSource moduleSource, final BuildableArtifactResolveResult result) {
        String description = "Resolve ".concat(artifact.toString());
        this.lockingManager.useCache(description, new Runnable(){

            @Override
            public void run() {
                CacheLockingArtifactResolver.this.delegate.resolveArtifact(artifact, moduleSource, result);
            }
        });
    }
}

