/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import org.gradle.api.Namer;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationComponentMetaDataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.reflect.Instantiator;

public class DefaultConfigurationContainer
extends AbstractNamedDomainObjectContainer<Configuration>
implements ConfigurationContainerInternal,
ConfigurationsProvider {
    public static final String DETACHED_CONFIGURATION_DEFAULT_NAME = "detachedConfiguration";
    private final ConfigurationResolver resolver;
    private final Instantiator instantiator;
    private final DomainObjectContext context;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final ProjectAccessListener projectAccessListener;
    private final ProjectFinder projectFinder;
    private final ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder;
    private final FileCollectionFactory fileCollectionFactory;
    private int detachedConfigurationDefaultNameCounter = 1;

    public DefaultConfigurationContainer(ConfigurationResolver resolver, Instantiator instantiator, DomainObjectContext context, ListenerManager listenerManager, DependencyMetaDataProvider dependencyMetaDataProvider, ProjectAccessListener projectAccessListener, ProjectFinder projectFinder, ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder, FileCollectionFactory fileCollectionFactory) {
        super(Configuration.class, instantiator, (Namer)new Configuration.Namer());
        this.resolver = resolver;
        this.instantiator = instantiator;
        this.context = context;
        this.listenerManager = listenerManager;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.projectAccessListener = projectAccessListener;
        this.projectFinder = projectFinder;
        this.configurationComponentMetaDataBuilder = configurationComponentMetaDataBuilder;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    protected Configuration doCreate(String name) {
        return (Configuration)this.instantiator.newInstance(DefaultConfiguration.class, new Object[]{this.context.absoluteProjectPath(name), name, this, this.resolver, this.listenerManager, this.dependencyMetaDataProvider, this.instantiator.newInstance(DefaultResolutionStrategy.class, new Object[0]), this.projectAccessListener, this.projectFinder, this.configurationComponentMetaDataBuilder, this.fileCollectionFactory});
    }

    @Override
    public Set<Configuration> getAll() {
        return this;
    }

    @Override
    public ConfigurationInternal getByName(String name) {
        return (ConfigurationInternal)super.getByName(name);
    }

    public String getTypeDisplayName() {
        return "configuration";
    }

    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownConfigurationException(String.format("Configuration with name '%s' not found.", name));
    }

    @Override
    public ConfigurationInternal detachedConfiguration(Dependency ... dependencies) {
        String name = DETACHED_CONFIGURATION_DEFAULT_NAME + this.detachedConfigurationDefaultNameCounter++;
        DetachedConfigurationsProvider detachedConfigurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration detachedConfiguration = new DefaultConfiguration(name, name, detachedConfigurationsProvider, this.resolver, this.listenerManager, this.dependencyMetaDataProvider, new DefaultResolutionStrategy(), this.projectAccessListener, this.projectFinder, this.configurationComponentMetaDataBuilder, this.fileCollectionFactory);
        DependencySet detachedDependencies = detachedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            detachedDependencies.add((Object)dependency.copy());
        }
        detachedConfigurationsProvider.setTheOnlyConfiguration(detachedConfiguration);
        return detachedConfiguration;
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("Configuration of type: " + this.getTypeDisplayName());
        Set<Configuration> configs = this.getAll();
        for (Configuration c : configs) {
            reply.append("\n  " + c.toString());
        }
        return reply.toString();
    }
}

