/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.callableReferences.CallableReferencesResolutionUtilsKt;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\u001cH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001eH\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\"H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010+\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010-\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/types/expressions/DoubleColonExpressionResolver;", "", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "callExpressionResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "reflectionTypes", "Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/builtins/ReflectionTypes;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "getCallExpressionResolver", "()Lorg/jetbrains/kotlin/resolve/calls/CallExpressionResolver;", "getCallResolver", "()Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "getDataFlowAnalyzer", "()Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "getReflectionTypes", "()Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "getTypeResolver", "()Lorg/jetbrains/kotlin/resolve/TypeResolver;", "checkNoExpressionOnLHS", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "c", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getCallableReferenceType", "Lorg/jetbrains/kotlin/types/KotlinType;", "lhsType", "context", "hasErrors", "", "trace", "Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;", "isAllowedInClassLiteral", "type", "isClassifierAvailableAtRuntime", "canBeNullable", "resolveClassLiteral", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitClassLiteralExpression", "kotlin-compiler"})
public final class DoubleColonExpressionResolver {
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final CallExpressionResolver callExpressionResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final TypeResolver typeResolver;

    @NotNull
    public final KotlinTypeInfo visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, @NotNull ExpressionTypingContext c) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(c, "c");
        KotlinType type2 = this.resolveClassLiteral(expression, c);
        if (type2 != null && !type2.isError()) {
            KotlinTypeInfo kotlinTypeInfo = this.dataFlowAnalyzer.createCheckedTypeInfo(this.reflectionTypes.getKClassType(Annotations.Companion.getEMPTY(), type2), c, expression);
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "dataFlowAnalyzer.createC\u2026TY, type), c, expression)");
            return kotlinTypeInfo;
        }
        return TypeInfoFactoryKt.createTypeInfo(ErrorUtils.createErrorType("Unresolved class"), c);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType resolveClassLiteral(KtClassLiteralExpression expression, ExpressionTypingContext c) {
        if (expression.isEmptyLHS()) {
            c.trace.report(Errors.UNSUPPORTED.on(expression, "Class literals with empty left hand side are not yet supported"));
            return null;
        }
        TypeResolutionContext context = new TypeResolutionContext(c.scope, c.trace, false, true, false);
        KtTypeReference ktTypeReference = expression.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        PossiblyBareType possiblyBareType = this.typeResolver.resolvePossiblyBareType(context, ktTypeReference);
        KotlinType type2 = null;
        if (possiblyBareType.isBare()) {
            ClassifierDescriptor descriptor2;
            if (!possiblyBareType.isNullable() && (descriptor2 = possiblyBareType.getBareTypeConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                List list2;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                if (KotlinBuiltIns.isNonPrimitiveArray((ClassDescriptor)descriptor2)) {
                    context.trace.report(Errors.ARRAY_CLASS_LITERAL_REQUIRES_ARGUMENT.on((KtExpression)((PsiElement)expression)));
                    return null;
                }
                Iterable iterable = ((ClassDescriptor)descriptor2).getTypeConstructor().getParameters();
                boolean bl = false;
                ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                KotlinTypeImpl.Companion companion = KotlinTypeImpl.Companion;
                void var12_13 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void p1;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
                    list2 = destination$iv$iv;
                    TypeProjection typeProjection = TypeUtils.makeStarProjection((TypeParameterDescriptor)p1);
                    list2.add(typeProjection);
                }
                list2 = (List)destination$iv$iv;
                type2 = companion.create(annotations2, classDescriptor, bl, list2);
            }
        } else {
            KotlinType actualType = possiblyBareType.getActualType();
            if (actualType.isError()) {
                return null;
            }
            KotlinType kotlinType = actualType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "actualType");
            if (this.isAllowedInClassLiteral(kotlinType)) {
                type2 = actualType;
            }
        }
        if (type2 != null) {
            return type2;
        }
        context.trace.report(Errors.CLASS_LITERAL_LHS_NOT_A_CLASS.on((KtExpression)((PsiElement)expression)));
        return null;
    }

    private final boolean isAllowedInClassLiteral(KotlinType type2) {
        return this.isClassifierAvailableAtRuntime(type2, false);
    }

    private final boolean isClassifierAvailableAtRuntime(KotlinType type2, boolean canBeNullable) {
        if (type2.isMarkedNullable() && !canBeNullable) {
            return false;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        ClassifierDescriptor typeDeclarationDescriptor = typeConstructor2.getDeclarationDescriptor();
        boolean typeIsArray = KotlinBuiltIns.isArray(type2);
        ClassifierDescriptor classifierDescriptor = typeDeclarationDescriptor;
        if (classifierDescriptor instanceof ClassDescriptor) {
            List<TypeParameterDescriptor> parameters2 = typeConstructor2.getParameters();
            if (parameters2.size() != type2.getArguments().size()) {
                return false;
            }
            Iterator<TypeProjection> typeArgumentsIterator = type2.getArguments().iterator();
            for (TypeParameterDescriptor parameter : parameters2) {
                TypeProjection typeArgument;
                if (!typeIsArray && !parameter.isReified()) {
                    return false;
                }
                if (typeArgumentsIterator.next() == null) {
                    return false;
                }
                if (typeArgument.isStarProjection()) {
                    return false;
                }
                KotlinType kotlinType = typeArgument.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "typeArgument.type");
                if (this.isClassifierAvailableAtRuntime(kotlinType, true)) continue;
                return false;
            }
            return true;
        }
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            return ((TypeParameterDescriptor)typeDeclarationDescriptor).isReified();
        }
        return false;
    }

    @NotNull
    public final KotlinTypeInfo visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression, @NotNull ExpressionTypingContext c) {
        KotlinType kotlinType;
        Object typeReference;
        KtTypeReference typeReference2;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(c, "c");
        KtTypeReference ktTypeReference = typeReference2 = expression.getTypeReference();
        if (ktTypeReference != null) {
            KtTypeReference ktTypeReference2 = ktTypeReference;
            typeReference = ktTypeReference2;
            LexicalScope lexicalScope = c.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "c.scope");
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
            kotlinType = this.typeResolver.resolveType(lexicalScope, (KtTypeReference)typeReference, bindingTrace, false);
        } else {
            kotlinType = null;
        }
        KotlinType receiverType = kotlinType;
        KtSimpleNameExpression callableReference = expression.getCallableReference();
        typeReference = callableReference.getReferencedName();
        if (typeReference.length() == 0) {
            c.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)callableReference), callableReference));
            KotlinType errorType = ErrorUtils.createErrorType("Empty callable reference");
            KotlinTypeInfo kotlinTypeInfo = this.dataFlowAnalyzer.createCheckedTypeInfo(errorType, c, expression);
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "dataFlowAnalyzer.createC\u2026errorType, c, expression)");
            return kotlinTypeInfo;
        }
        TemporaryBindingTrace trace = TemporaryBindingTrace.create(c.trace, "Callable reference type");
        ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)c.replaceBindingTrace(trace);
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "c.replaceBindingTrace(trace)");
        KotlinType result2 = this.getCallableReferenceType(expression, receiverType, expressionTypingContext);
        TemporaryBindingTrace temporaryBindingTrace = trace;
        Intrinsics.checkExpressionValueIsNotNull(temporaryBindingTrace, "trace");
        boolean hasErrors = this.hasErrors(temporaryBindingTrace);
        trace.commit();
        if (!hasErrors && result2 != null) {
            this.checkNoExpressionOnLHS(expression, c);
        }
        KotlinTypeInfo kotlinTypeInfo = this.dataFlowAnalyzer.createCheckedTypeInfo(result2, c, expression);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "dataFlowAnalyzer.createC\u2026fo(result, c, expression)");
        return kotlinTypeInfo;
    }

    private final boolean hasErrors(TemporaryBindingTrace trace) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = trace.getBindingContext().getDiagnostics().all();
            for (Object element$iv : $receiver$iv) {
                Diagnostic diagnostic = (Diagnostic)element$iv;
                if (!Intrinsics.areEqual((Object)diagnostic.getSeverity(), (Object)Severity.ERROR)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkNoExpressionOnLHS(KtCallableReferenceExpression expression, ExpressionTypingContext c) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        AssertionError assertionError;
        Object[] objectArray;
        Iterable destination$iv$iv2;
        Object element$iv$iv2;
        void $receiver$iv$iv2;
        void $receiver$iv2;
        KtTypeReference ktTypeReference = expression.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        if (!(ktTypeElement instanceof KtUserType)) {
            ktTypeElement = null;
        }
        KtUserType ktUserType = (KtUserType)ktTypeElement;
        if (ktUserType == null) {
            return;
        }
        KtUserType typeElement = ktUserType;
        while (true) {
            if (typeElement.getTypeArgumentList() != null) {
                return;
            }
            if (typeElement.getQualifier() != null) continue;
            break;
        }
        KtSimpleNameExpression ktSimpleNameExpression = typeElement.getReferenceExpression();
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression simpleNameExpression = ktSimpleNameExpression;
        TemporaryTraceAndCache traceAndCache = TemporaryTraceAndCache.create(c, "Resolve expression on LHS of callable reference", simpleNameExpression);
        ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)c.replaceTraceAndCache(traceAndCache);
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "c.replaceTraceAndCache(traceAndCache)");
        KtSimpleNameExpression ktSimpleNameExpression2 = simpleNameExpression;
        Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression2, "simpleNameExpression");
        OverloadResolutionResults<VariableDescriptor> resolutionResult = this.callExpressionResolver.resolveSimpleName(expressionTypingContext, ktSimpleNameExpression2);
        Object object = resolutionResult.getResultingCalls();
        String string = $receiver$iv2;
        Object[] objectArray2 = (Object[])new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            ResolvedCall call = (ResolvedCall)element$iv$iv2;
            if (!(call.getStatus().possibleTransformToSuccess() && !ErrorUtils.isError((DeclarationDescriptor)call.getResultingDescriptor()))) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List resultingCalls = (List)destination$iv$iv2;
        if (resultingCalls.isEmpty()) {
            return;
        }
        ResolvedCall resolvedCall2 = (ResolvedCall)CollectionsKt.singleOrNull(resultingCalls);
        if ((resolvedCall2 != null ? (VariableDescriptor)resolvedCall2.getResultingDescriptor() : null) instanceof FakeCallableDescriptorForObject) {
            return;
        }
        object = StringCompanionObject.INSTANCE;
        string = "Expressions on left-hand side of callable reference are not supported yet.\nResolution result: %s\nOriginal result: %s";
        destination$iv$iv2 = resultingCalls;
        int n = 0;
        Object object2 = objectArray = new Object[2];
        AssertionError assertionError2 = assertionError;
        AssertionError assertionError3 = assertionError;
        Iterator iterator2 = $receiver$iv;
        element$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void call;
            ResolvedCall $i$f$filterTo = (ResolvedCall)item$iv$iv;
            list2 = destination$iv$iv;
            VariableDescriptor variableDescriptor = (VariableDescriptor)call.getResultingDescriptor();
            list2.add(variableDescriptor);
        }
        list2 = (List)destination$iv$iv;
        objectArray[n] = list2;
        KtElement ktElement = expression.getCallableReference();
        BindingContext bindingContext = c.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "c.trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        object2[1] = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
        objectArray2 = object2;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
        object2 = string2;
        assertionError2(object2);
        throw (Throwable)((Object)assertionError3);
    }

    private final KotlinType getCallableReferenceType(KtCallableReferenceExpression expression, KotlinType lhsType, ExpressionTypingContext context) {
        DeclarationDescriptor containingDeclaration;
        KtSimpleNameExpression reference = expression.getCallableReference();
        boolean[] resolved = new boolean[1];
        CallableDescriptor descriptor2 = CallableReferencesResolutionUtilsKt.resolveCallableReferenceTarget(expression, lhsType, context, resolved, this.callResolver);
        if (!resolved[0]) {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)reference), reference));
        }
        if (descriptor2 == null) {
            return null;
        }
        if (expression.isEmptyLHS() && (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null)) {
            context.trace.report(Errors.CALLABLE_REFERENCE_TO_MEMBER_OR_EXTENSION_WITH_EMPTY_LHS.on((KtExpression)((PsiElement)reference)));
        }
        if (DescriptorUtils.isObject(containingDeclaration = descriptor2.getContainingDeclaration())) {
            context.trace.report(Errors.CALLABLE_REFERENCE_TO_OBJECT_MEMBER.on((KtExpression)((PsiElement)reference)));
        }
        if (descriptor2 instanceof ConstructorDescriptor && DescriptorUtils.isAnnotationClass(containingDeclaration)) {
            context.trace.report(Errors.CALLABLE_REFERENCE_TO_ANNOTATION_CONSTRUCTOR.on((KtExpression)((PsiElement)reference)));
        }
        return CallableReferencesResolutionUtilsKt.createReflectionTypeForResolvedCallableReference(expression, lhsType, descriptor2, context, this.reflectionTypes);
    }

    @NotNull
    public final CallResolver getCallResolver() {
        return this.callResolver;
    }

    @NotNull
    public final CallExpressionResolver getCallExpressionResolver() {
        return this.callExpressionResolver;
    }

    @NotNull
    public final DataFlowAnalyzer getDataFlowAnalyzer() {
        return this.dataFlowAnalyzer;
    }

    @NotNull
    public final ReflectionTypes getReflectionTypes() {
        return this.reflectionTypes;
    }

    @NotNull
    public final TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public DoubleColonExpressionResolver(@NotNull CallResolver callResolver, @NotNull CallExpressionResolver callExpressionResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull ReflectionTypes reflectionTypes, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkParameterIsNotNull(callResolver, "callResolver");
        Intrinsics.checkParameterIsNotNull(callExpressionResolver, "callExpressionResolver");
        Intrinsics.checkParameterIsNotNull(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(reflectionTypes, "reflectionTypes");
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        this.callResolver = callResolver;
        this.callExpressionResolver = callExpressionResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.reflectionTypes = reflectionTypes;
        this.typeResolver = typeResolver;
    }
}

