/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.relocated.com.google.common.base.Predicates;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUnifier;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

public class CastDiagnosticsUtil {
    public static boolean isCastPossible(@NotNull KotlinType lhsType, @NotNull KotlinType rhsType, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        if (lhsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lhsType", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isCastPossible"));
        }
        if (rhsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsType", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isCastPossible"));
        }
        if (platformToKotlinClassMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isCastPossible"));
        }
        if (KotlinBuiltIns.isNullableNothing(lhsType) && !TypeUtils.isNullableType(rhsType)) {
            return false;
        }
        if (CastDiagnosticsUtil.isRelated(lhsType, rhsType, platformToKotlinClassMap)) {
            return true;
        }
        if (TypeUtils.isTypeParameter(lhsType) || TypeUtils.isTypeParameter(rhsType)) {
            return true;
        }
        if (CastDiagnosticsUtil.isFinal(lhsType) || CastDiagnosticsUtil.isFinal(rhsType)) {
            return false;
        }
        return CastDiagnosticsUtil.isTrait(lhsType) || CastDiagnosticsUtil.isTrait(rhsType);
    }

    private static boolean isRelated(@NotNull KotlinType a, @NotNull KotlinType b, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isRelated"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isRelated"));
        }
        if (platformToKotlinClassMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isRelated"));
        }
        List<KotlinType> aTypes = CastDiagnosticsUtil.mapToPlatformIndependentTypes(TypeUtils.makeNotNullable(a), platformToKotlinClassMap);
        List<KotlinType> bTypes = CastDiagnosticsUtil.mapToPlatformIndependentTypes(TypeUtils.makeNotNullable(b), platformToKotlinClassMap);
        for (KotlinType aType : aTypes) {
            for (KotlinType bType : bTypes) {
                if (KotlinTypeChecker.DEFAULT.isSubtypeOf(aType, bType)) {
                    return true;
                }
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(bType, aType)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<KotlinType> mapToPlatformIndependentTypes(@NotNull KotlinType type2, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "mapToPlatformIndependentTypes"));
        }
        if (platformToKotlinClassMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "mapToPlatformIndependentTypes"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return Collections.singletonList(type2);
        }
        ClassDescriptor originalClass = (ClassDescriptor)descriptor2;
        Collection<ClassDescriptor> kotlinClasses = platformToKotlinClassMap.mapPlatformClass(originalClass);
        if (kotlinClasses.isEmpty()) {
            return Collections.singletonList(type2);
        }
        ArrayList<KotlinType> result2 = Lists.newArrayListWithCapacity(2);
        result2.add(type2);
        for (ClassDescriptor classDescriptor : kotlinClasses) {
            KotlinType kotlinType = TypeUtils.substituteProjectionsForParameters(classDescriptor, type2.getArguments());
            result2.add(kotlinType);
        }
        return result2;
    }

    private static boolean isFinal(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isFinal"));
        }
        return !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, type2);
    }

    private static boolean isTrait(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isTrait"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.INTERFACE;
    }

    public static boolean isCastErased(@NotNull KotlinType supertype, @NotNull KotlinType subtype, @NotNull KotlinTypeChecker typeChecker) {
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isCastErased"));
        }
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isCastErased"));
        }
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeChecker", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "isCastErased"));
        }
        if (supertype.isMarkedNullable() || subtype.isMarkedNullable()) {
            return CastDiagnosticsUtil.isCastErased(TypeUtils.makeNotNullable(supertype), TypeUtils.makeNotNullable(subtype), typeChecker);
        }
        if (typeChecker.isSubtypeOf(supertype, subtype)) {
            return false;
        }
        if (TypeUtils.isNonReifiedTypeParameter(subtype)) {
            return true;
        }
        if (CastDiagnosticsUtil.allParametersReified(subtype)) {
            return false;
        }
        KotlinType staticallyKnownSubtype = CastDiagnosticsUtil.findStaticallyKnownSubtype(supertype, subtype.getConstructor()).getResultingType();
        if (staticallyKnownSubtype == null) {
            return true;
        }
        return !typeChecker.isSubtypeOf(staticallyKnownSubtype, subtype);
    }

    public static TypeReconstructionResult findStaticallyKnownSubtype(@NotNull KotlinType supertype, @NotNull TypeConstructor subtypeConstructor) {
        HashMap<TypeConstructor, TypeProjection> substitution;
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "findStaticallyKnownSubtype"));
        }
        if (subtypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtypeConstructor", "org/jetbrains/kotlin/types/CastDiagnosticsUtil", "findStaticallyKnownSubtype"));
        }
        assert (!supertype.isMarkedNullable()) : "This method only makes sense for non-nullable types";
        ClassifierDescriptor descriptor2 = subtypeConstructor.getDeclarationDescriptor();
        assert (descriptor2 != null) : "Can't create default type for " + subtypeConstructor;
        KotlinType subtypeWithVariables = descriptor2.getDefaultType();
        KotlinType supertypeWithVariables = TypeCheckingProcedure.findCorrespondingSupertype(subtypeWithVariables, supertype);
        List<TypeParameterDescriptor> variables = subtypeWithVariables.getConstructor().getParameters();
        Set<TypeConstructor> variableConstructors = CollectionsKt.toSet(CollectionsKt.map(variables, new Function1<TypeParameterDescriptor, TypeConstructor>(){

            @Override
            public TypeConstructor invoke(TypeParameterDescriptor descriptor2) {
                return descriptor2.getTypeConstructor();
            }
        }));
        if (supertypeWithVariables != null) {
            TypeUnifier.UnificationResult solution = TypeUnifier.unify(new TypeProjectionImpl(supertype), new TypeProjectionImpl(supertypeWithVariables), Predicates.in(variableConstructors));
            substitution = Maps.newHashMap(solution.getSubstitution());
        } else {
            substitution = Maps.newHashMapWithExpectedSize(variables.size());
        }
        boolean allArgumentsInferred = true;
        for (TypeParameterDescriptor variable : variables) {
            TypeProjection value = (TypeProjection)substitution.get(variable.getTypeConstructor());
            if (value != null) continue;
            substitution.put(variable.getTypeConstructor(), TypeUtils.makeStarProjection(variable));
            allArgumentsInferred = false;
        }
        KotlinType substituted = TypeSubstitutor.create(substitution).substitute(subtypeWithVariables, Variance.INVARIANT);
        return new TypeReconstructionResult(substituted, allArgumentsInferred);
    }

    private static boolean allParametersReified(KotlinType subtype) {
        for (TypeParameterDescriptor parameterDescriptor : subtype.getConstructor().getParameters()) {
            if (parameterDescriptor.isReified()) continue;
            return false;
        }
        return true;
    }

    private CastDiagnosticsUtil() {
    }
}

