/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionKt;
import org.jetbrains.kotlin.script.ScriptNameUtil;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00140\u00160\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001bH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/script/StandardScriptDefinition;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "()V", "ARGS_NAME", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "name", "", "getName", "()Ljava/lang/String;", "getScriptDependenciesClasspath", "", "getScriptName", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "getScriptParameters", "Lorg/jetbrains/kotlin/script/ScriptParameter;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "getScriptSupertypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "getSuperclassConstructorParametersToScriptParametersMap", "Lkotlin/Pair;", "isScript", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "kotlin-compiler"})
public final class StandardScriptDefinition
implements KotlinScriptDefinition {
    private static final Name ARGS_NAME;
    @NotNull
    private static final String name = "Kotlin Script";
    public static final StandardScriptDefinition INSTANCE;

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public Name getScriptName(@NotNull KtScript script) {
        Intrinsics.checkParameterIsNotNull(script, "script");
        Name name = ScriptNameUtil.fileNameWithExtensionStripped(script, KotlinParserDefinition.STD_SCRIPT_EXT);
        Intrinsics.checkExpressionValueIsNotNull(name, "ScriptNameUtil.fileNameW\u2026efinition.STD_SCRIPT_EXT)");
        return name;
    }

    @Override
    public boolean isScript(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return Intrinsics.areEqual(PathUtil.getFileExtension(file.getName()), KotlinParserDefinition.STD_SCRIPT_SUFFIX);
    }

    @Override
    public boolean isScript(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return Intrinsics.areEqual(PathUtil.getFileExtension(file.getName()), KotlinParserDefinition.STD_SCRIPT_SUFFIX);
    }

    @Override
    @NotNull
    public List<ScriptParameter> getScriptParameters(@NotNull ScriptDescriptor scriptDescriptor) {
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Name name = ARGS_NAME;
        Intrinsics.checkExpressionValueIsNotNull(name, "ARGS_NAME");
        return KotlinScriptDefinitionKt.makeStringListScriptParameters(scriptDescriptor, name);
    }

    @Override
    @NotNull
    public List<KotlinType> getScriptSupertypes(@NotNull ScriptDescriptor scriptDescriptor) {
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<Pair<Name, KotlinType>> getSuperclassConstructorParametersToScriptParametersMap(@NotNull ScriptDescriptor scriptDescriptor) {
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<String> getScriptDependenciesClasspath() {
        return CollectionsKt.emptyList();
    }

    private StandardScriptDefinition() {
        INSTANCE = this;
        ARGS_NAME = Name.identifier("args");
        name = name;
    }

    static {
        new StandardScriptDefinition();
    }
}

