/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.org.jdom.Document;
import org.jetbrains.kotlin.relocated.org.jdom.Element;
import org.jetbrains.kotlin.relocated.org.jdom.output.Format;
import org.jetbrains.kotlin.relocated.org.jdom.output.XMLOutputter;
import org.jetbrains.kotlin.script.KotlinScriptConfig;
import org.jetbrains.kotlin.script.KotlinScriptParameterConfig;
import org.jetbrains.kotlin.script.ScriptConfigKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\t\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\t\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\t\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0012"}, d2={"SCRIPT_CONFIG_FILE_EXTENSION", "", "getSCRIPT_CONFIG_FILE_EXTENSION", "()Ljava/lang/String;", "generateSampleScriptConfig", "isScriptDefinitionConfigFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "loadScriptConfigs", "", "Lorg/jetbrains/kotlin/script/KotlinScriptConfig;", "configFile", "configStream", "Ljava/io/InputStream;", "loadScriptConfigsFromProjectRoot", "projectRoot", "kotlin-compiler"})
public final class ScriptConfigKt {
    @NotNull
    private static final String SCRIPT_CONFIG_FILE_EXTENSION = ".ktscfg.xml";

    @NotNull
    public static final String getSCRIPT_CONFIG_FILE_EXTENSION() {
        return SCRIPT_CONFIG_FILE_EXTENSION;
    }

    public static final boolean isScriptDefinitionConfigFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return file.isFile() && StringsKt.endsWith$default(file.getName(), SCRIPT_CONFIG_FILE_EXTENSION, false, 2, null);
    }

    public static final boolean isScriptDefinitionConfigFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return !file.isDirectory() && StringsKt.endsWith$default(file.getName(), SCRIPT_CONFIG_FILE_EXTENSION, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinScriptConfig> loadScriptConfigsFromProjectRoot(@NotNull File projectRoot) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(projectRoot, "projectRoot");
        Iterable $receiver$iv = SequencesKt.toList(SequencesKt.filter(FilesKt.walk$default(projectRoot, null, 1, null), loadScriptConfigsFromProjectRoot.1.INSTANCE));
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File it = (File)element$iv$iv;
            Iterable list$iv$iv = ScriptConfigKt.loadScriptConfigs(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinScriptConfig> loadScriptConfigs(@NotNull File configFile) {
        void var3_3;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(configFile, "configFile");
        Iterable $receiver$iv = JDOMUtil.loadDocument(configFile).getRootElement().getChildren();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void var4_4 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KotlinScriptConfig kotlinScriptConfig;
            Object element$iv$iv = element$iv$iv$iv;
            Element it = (Element)element$iv$iv;
            if (XmlSerializer.deserialize(it, KotlinScriptConfig.class) == null) continue;
            KotlinScriptConfig it$iv$iv = kotlinScriptConfig;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinScriptConfig> loadScriptConfigs(@NotNull InputStream configStream) {
        void var3_3;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(configStream, "configStream");
        Iterable $receiver$iv = JDOMUtil.loadDocument(configStream).getRootElement().getChildren();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void var4_4 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KotlinScriptConfig kotlinScriptConfig;
            Object element$iv$iv = element$iv$iv$iv;
            Element it = (Element)element$iv$iv;
            if (XmlSerializer.deserialize(it, KotlinScriptConfig.class) == null) continue;
            KotlinScriptConfig it$iv$iv = kotlinScriptConfig;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final String generateSampleScriptConfig() {
        Document doc = new Document(new Element("KotlinScriptDefinitions"));
        Element element = XmlSerializer.serialize(new KotlinScriptConfig("abc", ".*\\.kts", CollectionsKt.arrayListOf("aaa", "bbb"), CollectionsKt.arrayListOf(new KotlinScriptParameterConfig("p1", "t1")), null, null, 48, null));
        doc.getRootElement().addContent(element);
        StringWriter sw = new StringWriter();
        XMLOutputter xMLOutputter = new XMLOutputter();
        XMLOutputter $receiver = xMLOutputter;
        $receiver.setFormat(Format.getPrettyFormat());
        $receiver.output(doc, (Writer)sw);
        String string = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sw.toString()");
        return string;
    }

    static {
        SCRIPT_CONFIG_FILE_EXTENSION = SCRIPT_CONFIG_FILE_EXTENSION;
    }
}

