/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.serialization.deserialization.NotFoundClasses;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a&\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"getKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "kClass", "Lkotlin/reflect/KClass;", "", "getKotlinTypeByFqName", "fqName", "", "makeReflectedClassScriptParameter", "Lorg/jetbrains/kotlin/script/ScriptParameter;", "propertyName", "Lorg/jetbrains/kotlin/name/Name;", "makeStringListScriptParameters", "", "kotlin-compiler"})
public final class KotlinScriptDefinitionKt {
    @NotNull
    public static final List<ScriptParameter> makeStringListScriptParameters(@NotNull ScriptDescriptor scriptDescriptor, @NotNull Name propertyName) {
        KotlinType arrayOfStrings;
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(scriptDescriptor);
        KotlinType kotlinType = arrayOfStrings = builtIns.getArrayType(Variance.INVARIANT, builtIns.getStringType());
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "arrayOfStrings");
        return CollectionsKt.listOf(new ScriptParameter(propertyName, kotlinType));
    }

    @NotNull
    public static final ScriptParameter makeReflectedClassScriptParameter(@NotNull ScriptDescriptor scriptDescriptor, @NotNull Name propertyName, @NotNull KClass<? extends Object> kClass) {
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Intrinsics.checkParameterIsNotNull(kClass, "kClass");
        return new ScriptParameter(propertyName, KotlinScriptDefinitionKt.getKotlinType(scriptDescriptor, kClass));
    }

    @NotNull
    public static final KotlinType getKotlinType(@NotNull ScriptDescriptor scriptDescriptor, @NotNull KClass<? extends Object> kClass) {
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Intrinsics.checkParameterIsNotNull(kClass, "kClass");
        String string = kClass.getQualifiedName();
        if (string == null) {
            throw (Throwable)new RuntimeException("Cannot get FQN from " + kClass);
        }
        return KotlinScriptDefinitionKt.getKotlinTypeByFqName(scriptDescriptor, string);
    }

    @NotNull
    public static final KotlinType getKotlinTypeByFqName(@NotNull ScriptDescriptor scriptDescriptor, @NotNull String fqName2) {
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(scriptDescriptor);
        ClassId classId = ClassId.topLevel(new FqName(fqName2));
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(FqName(fqName))");
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkExpressionValueIsNotNull(storageManager, "LockBasedStorageManager.NO_LOCKS");
        KotlinType kotlinType = FindClassInModuleKt.findNonGenericClassAcrossDependencies(moduleDescriptor, classId, new NotFoundClasses(storageManager, DescriptorUtilsKt.getModule(scriptDescriptor))).getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "scriptDescriptor.module.\u2026le)\n        ).defaultType");
        return kotlinType;
    }
}

