/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.script.KotlinScriptExtraImport;
import org.jetbrains.kotlin.script.KotlinScriptExtraImportsProvider;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"getScriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getScriptExtraImports", "", "Lorg/jetbrains/kotlin/script/KotlinScriptExtraImport;", "kotlin-compiler"})
public final class GetScriptDefinitionKt {
    @Nullable
    public static final KotlinScriptDefinition getScriptDefinition(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(project, "project");
        return KotlinScriptDefinitionProvider.Companion.getInstance(project).findScriptDefinition(file);
    }

    @Nullable
    public static final KotlinScriptDefinition getScriptDefinition(@NotNull PsiFile psiFile) {
        Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
        Project project = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "psiFile.project");
        return KotlinScriptDefinitionProvider.Companion.getInstance(project).findScriptDefinition(psiFile);
    }

    @NotNull
    public static final List<KotlinScriptExtraImport> getScriptExtraImports(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(project, "project");
        Object object = KotlinScriptExtraImportsProvider.Companion.getInstance(project);
        if (object == null || (object = ((KotlinScriptExtraImportsProvider)object).getExtraImports(file)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<KotlinScriptExtraImport> getScriptExtraImports(@NotNull PsiFile psiFile) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
                object = psiFile.getVirtualFile();
                if (object == null) break block2;
                VirtualFile virtualFile = object;
                VirtualFile file = virtualFile;
                Project project = psiFile.getProject();
                Intrinsics.checkExpressionValueIsNotNull(project, "psiFile.project");
                KotlinScriptExtraImportsProvider kotlinScriptExtraImportsProvider = KotlinScriptExtraImportsProvider.Companion.getInstance(project);
                object = kotlinScriptExtraImportsProvider != null ? kotlinScriptExtraImportsProvider.getExtraImports(file) : null;
                if (object != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

