/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.relocated.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.DeclarationResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.OverloadResolver;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.VarianceChecker;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.ImportResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyScriptDescriptor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J2\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001e2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020*H\u0002J,\u00103\u001a\u00020'2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001eH\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/resolve/LazyTopDownAnalyzer;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "declarationResolver", "Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "overrideResolver", "Lorg/jetbrains/kotlin/resolve/OverrideResolver;", "overloadResolver", "Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "varianceChecker", "Lorg/jetbrains/kotlin/resolve/VarianceChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "lazyDeclarationResolver", "Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;", "bodyResolver", "Lorg/jetbrains/kotlin/resolve/BodyResolver;", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "fileScopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "declarationScopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/DeclarationResolver;Lorg/jetbrains/kotlin/resolve/OverrideResolver;Lorg/jetbrains/kotlin/resolve/OverloadResolver;Lorg/jetbrains/kotlin/resolve/VarianceChecker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;Lorg/jetbrains/kotlin/resolve/BodyResolver;Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProvider;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;)V", "analyzeDeclarations", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "topDownAnalysisMode", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisMode;", "declarations", "", "Lcom/intellij/psi/PsiElement;", "outerDataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "createFunctionDescriptors", "", "c", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "createPropertyDescriptors", "topLevelFqNames", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "properties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "registerTopLevelFqName", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolveAllHeadersInClasses", "kotlin-compiler"})
public final class LazyTopDownAnalyzer {
    private final BindingTrace trace;
    private final DeclarationResolver declarationResolver;
    private final OverrideResolver overrideResolver;
    private final OverloadResolver overloadResolver;
    private final VarianceChecker varianceChecker;
    private final ModuleDescriptor moduleDescriptor;
    private final LazyDeclarationResolver lazyDeclarationResolver;
    private final BodyResolver bodyResolver;
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    private final FileScopeProvider fileScopeProvider;
    private final DeclarationScopeProvider declarationScopeProvider;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final IdentifierChecker identifierChecker;

    @NotNull
    public final TopDownAnalysisContext analyzeDeclarations(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull Collection<? extends PsiElement> declarations, @NotNull DataFlowInfo outerDataFlowInfo) {
        Intrinsics.checkParameterIsNotNull((Object)topDownAnalysisMode, "topDownAnalysisMode");
        Intrinsics.checkParameterIsNotNull(declarations, "declarations");
        Intrinsics.checkParameterIsNotNull(outerDataFlowInfo, "outerDataFlowInfo");
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisMode, outerDataFlowInfo, this.declarationScopeProvider);
        HashMultimap topLevelFqNames = HashMultimap.create();
        ArrayList properties2 = new ArrayList();
        ArrayList functions2 = new ArrayList();
        for (PsiElement psiElement : declarations) {
            psiElement.accept(new KtVisitorVoid(this, c, topLevelFqNames, functions2, properties2){
                final /* synthetic */ LazyTopDownAnalyzer this$0;
                final /* synthetic */ TopDownAnalysisContext $c;
                final /* synthetic */ HashMultimap $topLevelFqNames;
                final /* synthetic */ ArrayList $functions;
                final /* synthetic */ ArrayList $properties;

                private final void registerDeclarations(List<? extends KtDeclaration> declarations) {
                    for (KtDeclaration ktDeclaration : declarations) {
                        ktDeclaration.accept(this);
                    }
                }

                public void visitDeclaration(@NotNull KtDeclaration dcl) {
                    Intrinsics.checkParameterIsNotNull(dcl, "dcl");
                    throw (Throwable)new IllegalArgumentException("Unsupported declaration: " + dcl + " " + dcl.getText());
                }

                public void visitScript(@NotNull KtScript script) {
                    Intrinsics.checkParameterIsNotNull(script, "script");
                    ScriptDescriptor scriptDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).getScriptDescriptor(script, new KotlinLookupLocation(script));
                    if (scriptDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.lazy.descriptors.LazyScriptDescriptor");
                    }
                    this.$c.getScripts().put(script, (LazyScriptDescriptor)scriptDescriptor);
                    List<KtDeclaration> list2 = script.getDeclarations();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "script.declarations");
                    this.registerDeclarations(list2);
                }

                public void visitKtFile(@NotNull KtFile file) {
                    Intrinsics.checkParameterIsNotNull(file, "file");
                    DescriptorResolver.registerFileInPackage(LazyTopDownAnalyzer.access$getTrace$p(this.this$0), file);
                    List<KtDeclaration> list2 = file.getDeclarations();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "file.declarations");
                    this.registerDeclarations(list2);
                    KtPackageDirective packageDirective = file.getPackageDirective();
                    boolean bl = file.isScript() || packageDirective != null;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "No package in a non-script file: " + file;
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    KtPackageDirective ktPackageDirective = packageDirective;
                    if (ktPackageDirective != null) {
                        ktPackageDirective.accept(this);
                    }
                    this.$c.addFile(file);
                    this.$topLevelFqNames.put(file.getPackageFqName(), packageDirective);
                }

                public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                    Intrinsics.checkParameterIsNotNull(directive, "directive");
                    Iterable $receiver$iv = directive.getPackageNames();
                    for (T element$iv : $receiver$iv) {
                        KtSimpleNameExpression it = (KtSimpleNameExpression)element$iv;
                        LazyTopDownAnalyzer.access$getIdentifierChecker$p(this.this$0).checkIdentifier(it.getIdentifier(), LazyTopDownAnalyzer.access$getTrace$p(this.this$0));
                    }
                    LazyTopDownAnalyzer.access$getQualifiedExpressionResolver$p(this.this$0).resolvePackageHeader(directive, LazyTopDownAnalyzer.access$getModuleDescriptor$p(this.this$0), LazyTopDownAnalyzer.access$getTrace$p(this.this$0));
                }

                public void visitImportDirective(@NotNull KtImportDirective importDirective) {
                    Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
                    FileScopeProvider fileScopeProvider = LazyTopDownAnalyzer.access$getFileScopeProvider$p(this.this$0);
                    KtFile ktFile = importDirective.getContainingKtFile();
                    Intrinsics.checkExpressionValueIsNotNull(ktFile, "importDirective.getContainingKtFile()");
                    ImportResolver importResolver2 = fileScopeProvider.getImportResolver(ktFile);
                    importResolver2.forceResolveImport(importDirective);
                }

                public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                    Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
                    LookupLocation location2 = classOrObject.isTopLevel() ? (LookupLocation)new KotlinLookupLocation(classOrObject) : (LookupLocation)NoLookupLocation.WHEN_RESOLVE_DECLARATION;
                    ClassDescriptor classDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).getClassDescriptor(classOrObject, location2);
                    if (classDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    }
                    ClassDescriptorWithResolutionScopes descriptor2 = (ClassDescriptorWithResolutionScopes)classDescriptor;
                    this.$c.getDeclaredClasses().put(classOrObject, descriptor2);
                    this.registerDeclarations(classOrObject.getDeclarations());
                    Multimap multimap = this.$topLevelFqNames;
                    Intrinsics.checkExpressionValueIsNotNull(multimap, "topLevelFqNames");
                    LazyTopDownAnalyzer.access$registerTopLevelFqName(this.this$0, multimap, classOrObject, descriptor2);
                    this.checkClassOrObjectDeclarations(classOrObject, descriptor2);
                }

                private final void checkClassOrObjectDeclarations(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
                    boolean companionObjectAlreadyFound = false;
                    for (KtDeclaration jetDeclaration : classOrObject.getDeclarations()) {
                        if (jetDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)jetDeclaration).isCompanion()) {
                            if (companionObjectAlreadyFound) {
                                LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.MANY_COMPANION_OBJECTS.on((KtObjectDeclaration)jetDeclaration));
                            }
                            companionObjectAlreadyFound = true;
                            continue;
                        }
                        if (!(jetDeclaration instanceof KtSecondaryConstructor)) continue;
                        if (DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor)) {
                            LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)jetDeclaration)));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE))) continue;
                        LazyTopDownAnalyzer.access$getTrace$p(this.this$0).report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)jetDeclaration)));
                    }
                }

                public void visitClass(@NotNull KtClass klass) {
                    Intrinsics.checkParameterIsNotNull(klass, "klass");
                    this.visitClassOrObject(klass);
                    this.registerPrimaryConstructorParameters(klass);
                }

                private final void registerPrimaryConstructorParameters(KtClass klass) {
                    for (KtParameter jetParameter : klass.getPrimaryConstructorParameters()) {
                        if (!jetParameter.hasValOrVar()) continue;
                        DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(jetParameter);
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                        }
                        this.$c.getPrimaryConstructorParameterProperties().put(jetParameter, (PropertyDescriptor)declarationDescriptor);
                    }
                }

                public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
                    Intrinsics.checkParameterIsNotNull(constructor, "constructor");
                    DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(constructor);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ConstructorDescriptor");
                    }
                    this.$c.getSecondaryConstructors().put(constructor, (ConstructorDescriptor)declarationDescriptor);
                }

                public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
                    Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
                    this.visitClassOrObject(enumEntry);
                }

                public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    this.visitClassOrObject(declaration);
                }

                public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2) {
                    Intrinsics.checkParameterIsNotNull(initializer2, "initializer");
                    DeclarationDescriptor declarationDescriptor = LazyTopDownAnalyzer.access$getLazyDeclarationResolver$p(this.this$0).resolveToDescriptor(initializer2.getContainingDeclaration());
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                    }
                    ClassDescriptorWithResolutionScopes containerDescriptor = (ClassDescriptorWithResolutionScopes)declarationDescriptor;
                    this.$c.getAnonymousInitializers().put(initializer2, containerDescriptor);
                }

                public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                    Intrinsics.checkParameterIsNotNull(destructuringDeclaration, "destructuringDeclaration");
                }

                public void visitNamedFunction(@NotNull KtNamedFunction function) {
                    Intrinsics.checkParameterIsNotNull(function, "function");
                    this.$functions.add(function);
                }

                public void visitProperty(@NotNull KtProperty property) {
                    Intrinsics.checkParameterIsNotNull(property, "property");
                    this.$properties.add(property);
                }
                {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$topLevelFqNames = $captured_local_variable$2;
                    this.$functions = $captured_local_variable$3;
                    this.$properties = $captured_local_variable$4;
                }
            });
        }
        this.createFunctionDescriptors(c, functions2);
        Multimap multimap = topLevelFqNames;
        Intrinsics.checkExpressionValueIsNotNull(multimap, "topLevelFqNames");
        this.createPropertyDescriptors(c, multimap, properties2);
        this.resolveAllHeadersInClasses(c);
        Multimap multimap2 = topLevelFqNames;
        Intrinsics.checkExpressionValueIsNotNull(multimap2, "topLevelFqNames");
        this.declarationResolver.checkRedeclarationsInPackages(this.topLevelDescriptorProvider, multimap2);
        this.declarationResolver.checkRedeclarations(c);
        this.overrideResolver.check(c);
        this.varianceChecker.check(c);
        this.declarationResolver.resolveAnnotationsOnFiles(c, this.fileScopeProvider);
        this.overloadResolver.checkOverloads(c);
        this.bodyResolver.resolveBodies(c);
        return c;
    }

    private final void resolveAllHeadersInClasses(TopDownAnalysisContext c) {
        Iterator<ClassDescriptorWithResolutionScopes> iterator2 = c.getAllClasses().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes classDescriptor;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor = iterator2.next();
            if (classDescriptorWithResolutionScopes == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor");
            }
            ((LazyClassDescriptor)classDescriptorWithResolutionScopes).resolveMemberHeaders();
        }
    }

    private final void createPropertyDescriptors(TopDownAnalysisContext c, Multimap<FqName, KtElement> topLevelFqNames, List<? extends KtProperty> properties2) {
        for (KtProperty ktProperty : properties2) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(ktProperty);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
            }
            PropertyDescriptor descriptor2 = (PropertyDescriptor)declarationDescriptor;
            c.getProperties().put(ktProperty, descriptor2);
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            this.registerTopLevelFqName(topLevelFqNames, ktProperty, descriptor2);
        }
    }

    private final void createFunctionDescriptors(TopDownAnalysisContext c, List<? extends KtNamedFunction> functions2) {
        for (KtNamedFunction ktNamedFunction : functions2) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(ktNamedFunction);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)declarationDescriptor;
            c.getFunctions().put(ktNamedFunction, simpleFunctionDescriptor);
            ForceResolveUtil.forceResolveAllContents(simpleFunctionDescriptor.getAnnotations());
            for (ValueParameterDescriptor parameterDescriptor : simpleFunctionDescriptor.getValueParameters()) {
                ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
            }
        }
    }

    private final void registerTopLevelFqName(Multimap<FqName, KtElement> topLevelFqNames, KtNamedDeclaration declaration, DeclarationDescriptor descriptor2) {
        FqName fqName2;
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && (fqName2 = declaration.getFqName()) != null) {
            topLevelFqNames.put(fqName2, declaration);
        }
    }

    public LazyTopDownAnalyzer(@NotNull BindingTrace trace, @NotNull DeclarationResolver declarationResolver, @NotNull OverrideResolver overrideResolver, @NotNull OverloadResolver overloadResolver, @NotNull VarianceChecker varianceChecker, @NotNull ModuleDescriptor moduleDescriptor, @NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull BodyResolver bodyResolver, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull FileScopeProvider fileScopeProvider, @NotNull DeclarationScopeProvider declarationScopeProvider, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull IdentifierChecker identifierChecker) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(declarationResolver, "declarationResolver");
        Intrinsics.checkParameterIsNotNull(overrideResolver, "overrideResolver");
        Intrinsics.checkParameterIsNotNull(overloadResolver, "overloadResolver");
        Intrinsics.checkParameterIsNotNull(varianceChecker, "varianceChecker");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(lazyDeclarationResolver, "lazyDeclarationResolver");
        Intrinsics.checkParameterIsNotNull(bodyResolver, "bodyResolver");
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(fileScopeProvider, "fileScopeProvider");
        Intrinsics.checkParameterIsNotNull(declarationScopeProvider, "declarationScopeProvider");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull(identifierChecker, "identifierChecker");
        this.trace = trace;
        this.declarationResolver = declarationResolver;
        this.overrideResolver = overrideResolver;
        this.overloadResolver = overloadResolver;
        this.varianceChecker = varianceChecker;
        this.moduleDescriptor = moduleDescriptor;
        this.lazyDeclarationResolver = lazyDeclarationResolver;
        this.bodyResolver = bodyResolver;
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        this.fileScopeProvider = fileScopeProvider;
        this.declarationScopeProvider = declarationScopeProvider;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.identifierChecker = identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ LazyDeclarationResolver access$getLazyDeclarationResolver$p(LazyTopDownAnalyzer $this) {
        return $this.lazyDeclarationResolver;
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTrace$p(LazyTopDownAnalyzer $this) {
        return $this.trace;
    }

    @NotNull
    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(LazyTopDownAnalyzer $this) {
        return $this.identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ QualifiedExpressionResolver access$getQualifiedExpressionResolver$p(LazyTopDownAnalyzer $this) {
        return $this.qualifiedExpressionResolver;
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(LazyTopDownAnalyzer $this) {
        return $this.moduleDescriptor;
    }

    @NotNull
    public static final /* synthetic */ FileScopeProvider access$getFileScopeProvider$p(LazyTopDownAnalyzer $this) {
        return $this.fileScopeProvider;
    }

    public static final /* synthetic */ void access$registerTopLevelFqName(LazyTopDownAnalyzer $this, @NotNull Multimap topLevelFqNames, @NotNull KtNamedDeclaration declaration, @NotNull DeclarationDescriptor descriptor2) {
        $this.registerTopLevelFqName(topLevelFqNames, declaration, descriptor2);
    }
}

