/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast;

import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u00060\bR\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0018\u00010\bR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "parent", "description", "", "(Lcom/google/dart/compiler/backend/js/ast/JsScope;Ljava/lang/String;)V", "labelScopes", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "topLabelScope", "getTopLabelScope", "()Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "declareName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "identifier", "declareNameUnsafe", "enterLabel", "label", "exitLabel", "", "findLabel", "hasOwnName", "", "name", "Companion", "LabelScope", "kotlin-compiler"})
public class JsFunctionScope
extends JsScope {
    private final Stack<LabelScope> labelScopes;
    @NotNull
    private static final Set<String> RESERVED_WORDS;
    public static final Companion Companion;

    private final LabelScope getTopLabelScope() {
        Collection collection = this.labelScopes;
        return !collection.isEmpty() ? this.labelScopes.peek() : (LabelScope)null;
    }

    @Override
    @NotNull
    public JsName declareName(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        JsName jsName = super.declareFreshName(identifier);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "super.declareFreshName(identifier)");
        return jsName;
    }

    @Override
    public boolean hasOwnName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return Companion.getRESERVED_WORDS().contains(name) || super.hasOwnName(name);
    }

    @NotNull
    public JsName declareNameUnsafe(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        JsName jsName = super.declareName(identifier);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "super.declareName(identifier)");
        return jsName;
    }

    @NotNull
    public JsName enterLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        LabelScope scope = new LabelScope(this.getTopLabelScope(), label);
        this.labelScopes.push(scope);
        return scope.getLabelName();
    }

    public void exitLabel() {
        Collection collection = this.labelScopes;
        boolean bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "No scope to exit from";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.labelScopes.pop();
    }

    @Nullable
    public JsName findLabel(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        LabelScope labelScope = this.getTopLabelScope();
        return labelScope != null ? labelScope.findName(label) : null;
    }

    public JsFunctionScope(@NotNull JsScope parent2, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull(parent2, "parent");
        Intrinsics.checkParameterIsNotNull(description, "description");
        super(parent2, description, null);
        this.labelScopes = new Stack();
    }

    static {
        Companion = new Companion(null);
        RESERVED_WORDS = SetsKt.setOf(new String[]{"await", "break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "null", "true", "false", "eval", "arguments", "NaN", "Infinity", "undefined", "Kotlin"});
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsScope;", "parent", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope;", "ident", "", "(Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope$LabelScope;Ljava/lang/String;)V", "getIdent", "()Ljava/lang/String;", "labelName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "getLabelName", "()Lcom/google/dart/compiler/backend/js/ast/JsName;", "findOwnName", "name", "hasOwnName", "", "kotlin-compiler"})
    private final class LabelScope
    extends JsScope {
        @NotNull
        private final JsName labelName;
        @NotNull
        private final String ident;

        @NotNull
        public final JsName getLabelName() {
            return this.labelName;
        }

        @Override
        @Nullable
        protected JsName findOwnName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return Intrinsics.areEqual(name, this.ident) ? this.labelName : (JsName)null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasOwnName(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            if (Companion.getRESERVED_WORDS().contains(name)) return true;
            if (Intrinsics.areEqual(name, this.ident)) return true;
            JsName jsName = this.labelName;
            if (Intrinsics.areEqual(name, jsName != null ? jsName.getIdent() : null)) return true;
            JsScope jsScope = this.getParent();
            if (jsScope == null) return false;
            boolean bl = jsScope.hasOwnName(name);
            if (!bl) return false;
            return true;
        }

        public LabelScope(@Nullable LabelScope parent2, @NotNull String ident) {
            Intrinsics.checkParameterIsNotNull(ident, "ident");
            super(parent2, "Label scope for " + ident, null);
            this.ident = ident;
            String freshIdent = Companion.getRESERVED_WORDS().contains(this.ident) ? this.getFreshIdent(this.ident) : (parent2 != null ? parent2.getFreshIdent(this.ident) : this.ident);
            this.labelName = new JsName(JsFunctionScope.this, freshIdent);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsFunctionScope$Companion;", "", "()V", "RESERVED_WORDS", "", "", "getRESERVED_WORDS", "()Ljava/util/Set;", "kotlin-compiler"})
    public static final class Companion {
        @NotNull
        public final Set<String> getRESERVED_WORDS() {
            return RESERVED_WORDS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

