/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001c\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallableReferenceTranslator;", "", "()V", "isConstructor", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isExtension", "isMember", "isVar", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "reportNotSupported", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "expression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "translate", "translateAsMemberFunctionReference", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "translateForConstructor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "translateForExtensionFunction", "translateForExtensionProperty", "translateForFunction", "translateForMemberFunction", "translateForMemberProperty", "translateForProperty", "translateForTopLevelProperty", "kotlin-compiler"})
public final class CallableReferenceTranslator {
    public static final CallableReferenceTranslator INSTANCE;

    @NotNull
    public final JsExpression translate(@NotNull KtCallableReferenceExpression expression, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        DeclarationDescriptor descriptor2;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DeclarationDescriptor declarationDescriptor = descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression.getCallableReference());
        if (declarationDescriptor instanceof PropertyDescriptor) {
            jsExpression = this.translateForProperty((PropertyDescriptor)descriptor2, context, expression);
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            jsExpression = this.translateForFunction((FunctionDescriptor)descriptor2, context, expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Expected property or function: " + descriptor2 + ", expression=" + expression.getText());
        }
        return jsExpression;
    }

    private final JsExpression reportNotSupported(TranslationContext context, KtCallableReferenceExpression expression) {
        context.bindingTrace().report(ErrorsJs.REFERENCE_TO_BUILTIN_MEMBERS_NOT_SUPPORTED.on((KtElement)((PsiElement)expression), expression));
        JsExpression jsExpression = context.getEmptyExpression();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "context.emptyExpression");
        return jsExpression;
    }

    private final JsExpression translateForFunction(FunctionDescriptor descriptor2, TranslationContext context, KtCallableReferenceExpression expression) {
        JsExpression jsExpression;
        if (JsDescriptorUtils.isBuiltin(descriptor2)) {
            jsExpression = this.reportNotSupported(context, expression);
        } else if (this.isConstructor(descriptor2)) {
            jsExpression = this.translateForConstructor(descriptor2, context);
        } else if (this.isExtension(descriptor2)) {
            jsExpression = this.translateForExtensionFunction(descriptor2, context);
        } else if (this.isMember(descriptor2)) {
            jsExpression = this.translateForMemberFunction(descriptor2, context);
        } else {
            JsExpression jsExpression2 = ReferenceTranslator.translateAsFQReference(descriptor2, context);
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "ReferenceTranslator.tran\u2026ence(descriptor, context)");
        }
        return jsExpression;
    }

    private final JsExpression translateForProperty(PropertyDescriptor descriptor2, TranslationContext context, KtCallableReferenceExpression expression) {
        return JsDescriptorUtils.isBuiltin(descriptor2) ? this.reportNotSupported(context, expression) : (this.isExtension(descriptor2) ? this.translateForExtensionProperty(descriptor2, context) : (this.isMember(descriptor2) ? this.translateForMemberProperty(descriptor2, context) : this.translateForTopLevelProperty(descriptor2, context)));
    }

    private final boolean isConstructor(CallableDescriptor descriptor2) {
        return descriptor2 instanceof ConstructorDescriptor;
    }

    private final boolean isExtension(CallableDescriptor descriptor2) {
        return DescriptorUtils.isExtension(descriptor2);
    }

    private final boolean isMember(CallableDescriptor descriptor2) {
        return JsDescriptorUtils.getContainingDeclaration(descriptor2) instanceof ClassDescriptor;
    }

    private final JsExpression isVar(PropertyDescriptor descriptor2) {
        JsExpression jsExpression;
        if (descriptor2.isVar()) {
            JsExpression jsExpression2 = JsLiteral.TRUE;
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "JsLiteral.TRUE");
        } else {
            JsExpression jsExpression3 = JsLiteral.FALSE;
            jsExpression = jsExpression3;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "JsLiteral.FALSE");
        }
        return jsExpression;
    }

    private final JsExpression translateForTopLevelProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        DeclarationDescriptor packageDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor2);
        boolean bl = packageDescriptor instanceof PackageFragmentDescriptor;
        if (_Assertions.ENABLED && !bl) {
            String string = "Expected PackageFragmentDescriptor: " + packageDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        JsNameRef jsPackageNameRef = context.getQualifiedReference(packageDescriptor);
        JsName jsPropertyName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context.namer().callableRefForTopLevelPropertyReference(), jsPackageNameRef, jsPropertyNameAsString, this.isVar(descriptor2));
    }

    private final JsExpression translateForMemberProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        JsName jsPropertyName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context.namer().callableRefForMemberPropertyReference(), jsPropertyNameAsString, this.isVar(descriptor2));
    }

    private final JsExpression translateForExtensionProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
        if (propertyGetterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef jsGetterNameRef = context.getQualifiedReference(propertyGetterDescriptor);
        Name propertyName = descriptor2.getName();
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(propertyName.asString());
        ArrayList<JsExpressionImpl> argumentList2 = new ArrayList<JsExpressionImpl>(3);
        argumentList2.add(jsPropertyNameAsString);
        argumentList2.add(jsGetterNameRef);
        if (descriptor2.isVar()) {
            PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
            if (propertySetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            JsNameRef jsSetterNameRef = context.getQualifiedReference(propertySetterDescriptor);
            argumentList2.add(jsSetterNameRef);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            return this.translateForMemberProperty(descriptor2, context);
        }
        return new JsInvocation(context.namer().callableRefForExtensionPropertyReference(), (List<JsExpression>)argumentList2);
    }

    private final JsExpression translateForConstructor(FunctionDescriptor descriptor2, TranslationContext context) {
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor2, context);
        return new JsInvocation(context.namer().callableRefForConstructorReference(), jsFunctionRef);
    }

    private final JsExpression translateForExtensionFunction(FunctionDescriptor descriptor2, TranslationContext context) {
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        boolean bl = receiverParameterDescriptor != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "receiverParameter for extension should not be null";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor2, context);
        if (Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.LOCAL)) {
            return new JsInvocation(context.namer().callableRefForLocalExtensionFunctionReference(), jsFunctionRef);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            KotlinType jetType = receiverParameterDescriptor2.getType();
            ClassDescriptor receiverClassDescriptor = DescriptorUtils.getClassDescriptorForType(jetType);
            CallableDescriptor callableDescriptor = descriptor2;
            ClassDescriptor classDescriptor = receiverClassDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "receiverClassDescriptor");
            return this.translateAsMemberFunctionReference(callableDescriptor, classDescriptor, context);
        }
        return new JsInvocation(context.namer().callableRefForExtensionFunctionReference(), jsFunctionRef);
    }

    private final JsExpression translateForMemberFunction(FunctionDescriptor descriptor2, TranslationContext context) {
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor2);
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException("Expected ClassDescriptor: " + descriptor2);
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return this.translateAsMemberFunctionReference(descriptor2, classDescriptor2, context);
    }

    private final JsExpression translateAsMemberFunctionReference(CallableDescriptor descriptor2, ClassDescriptor classDescriptor, TranslationContext context) {
        JsNameRef jsClassNameRef = context.getQualifiedReference(classDescriptor);
        JsName funName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral funNameAsString = context.program().getStringLiteral(funName.toString());
        return new JsInvocation(context.namer().callableRefForMemberFunctionReference(), jsClassNameRef, funNameAsString);
    }

    private CallableReferenceTranslator() {
        INSTANCE = this;
    }

    static {
        new CallableReferenceTranslator();
    }
}

