/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.js.translate.context.DefinitionPlace;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DefineInvocation;
import org.jetbrains.kotlin.js.translate.declaration.FileDeclarationVisitor;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsObjectScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;

final class PackageTranslator
extends AbstractTranslator {
    @NotNull
    private final PackageFragmentDescriptor descriptor;
    private final FileDeclarationVisitor visitor;

    static PackageTranslator create(@NotNull PackageFragmentDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/declaration/PackageTranslator", "create"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/declaration/PackageTranslator", "create"));
        }
        JsScope scope = context.getScopeForDescriptor(descriptor2);
        JsNameRef reference = context.getQualifiedReference(descriptor2);
        SmartList<JsPropertyInitializer> properties2 = new SmartList<JsPropertyInitializer>();
        DefinitionPlace definitionPlace = new DefinitionPlace((JsObjectScope)scope, reference, properties2);
        TranslationContext newContext = context.newDeclaration(descriptor2, definitionPlace);
        FileDeclarationVisitor visitor2 = new FileDeclarationVisitor(newContext, definitionPlace.getProperties());
        return new PackageTranslator(descriptor2, newContext, visitor2);
    }

    private PackageTranslator(@NotNull PackageFragmentDescriptor descriptor2, @NotNull TranslationContext context, @NotNull FileDeclarationVisitor visitor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/declaration/PackageTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/declaration/PackageTranslator", "<init>"));
        }
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/js/translate/declaration/PackageTranslator", "<init>"));
        }
        super(context);
        this.descriptor = descriptor2;
        this.visitor = visitor2;
    }

    public void translate(KtFile file) {
        for (KtDeclaration declaration : file.getDeclarations()) {
            if (AnnotationsUtils.isPredefinedObject(BindingUtils.getDescriptorForElement(this.bindingContext(), declaration))) continue;
            declaration.accept(this.visitor, this.context());
        }
    }

    private void createDefinitionPlace(@Nullable JsExpression initializer2, Map<FqName, DefineInvocation> packageFqNameToDefineInvocation) {
        FqName fqName2 = this.descriptor.getFqName();
        DefineInvocation place = DefineInvocation.create(fqName2, initializer2, new JsObjectLiteral(this.visitor.getResult(), true), this.context());
        packageFqNameToDefineInvocation.put(fqName2, place);
        this.addToParent(fqName2.parent(), this.getEntry(fqName2, place), packageFqNameToDefineInvocation);
    }

    public void add(@NotNull Map<FqName, DefineInvocation> packageFqNameToDefineInvocation) {
        if (packageFqNameToDefineInvocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqNameToDefineInvocation", "org/jetbrains/kotlin/js/translate/declaration/PackageTranslator", "add"));
        }
        JsFunction initializer2 = this.visitor.computeInitializer();
        DefineInvocation defineInvocation = packageFqNameToDefineInvocation.get(this.descriptor.getFqName());
        if (defineInvocation == null) {
            if (initializer2 != null || !this.visitor.getResult().isEmpty()) {
                this.createDefinitionPlace(initializer2, packageFqNameToDefineInvocation);
            }
        } else {
            List<JsPropertyInitializer> listFromPlace;
            if (initializer2 != null) {
                assert (defineInvocation.getInitializer() == JsLiteral.NULL);
                defineInvocation.setInitializer(initializer2);
            }
            if ((listFromPlace = defineInvocation.getMembers()) != this.visitor.getResult()) {
                listFromPlace.addAll(this.visitor.getResult());
            }
        }
    }

    private JsPropertyInitializer getEntry(@NotNull FqName fqName2, DefineInvocation defineInvocation) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/js/translate/declaration/PackageTranslator", "getEntry"));
        }
        return new JsPropertyInitializer(this.context().getNameForPackage(fqName2).makeRef(), new JsInvocation(this.context().namer().packageDefinitionMethodReference(), defineInvocation.asList()));
    }

    private static boolean addEntryIfParentExists(FqName parentFqName, JsPropertyInitializer entry, Map<FqName, DefineInvocation> packageFqNameToDeclarationPlace) {
        DefineInvocation parentDefineInvocation = packageFqNameToDeclarationPlace.get(parentFqName);
        if (parentDefineInvocation != null) {
            parentDefineInvocation.getMembers().add(entry);
            return true;
        }
        return false;
    }

    private void addToParent(@NotNull FqName parentFqName, JsPropertyInitializer entry, Map<FqName, DefineInvocation> packageFqNameToDefineInvocation) {
        if (parentFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFqName", "org/jetbrains/kotlin/js/translate/declaration/PackageTranslator", "addToParent"));
        }
        while (!PackageTranslator.addEntryIfParentExists(parentFqName, entry, packageFqNameToDefineInvocation)) {
            JsObjectLiteral members2 = new JsObjectLiteral(new SmartList<JsPropertyInitializer>(entry), true);
            DefineInvocation defineInvocation = DefineInvocation.create(parentFqName, null, members2, this.context());
            entry = this.getEntry(parentFqName, defineInvocation);
            packageFqNameToDefineInvocation.put(parentFqName, defineInvocation);
            parentFqName = parentFqName.parent();
        }
    }
}

