/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class DebugInfoUtil {
    private static final TokenSet MAY_BE_UNRESOLVED = TokenSet.create(KtTokens.IN_KEYWORD, KtTokens.NOT_IN);
    private static final TokenSet EXCLUDED = TokenSet.create(KtTokens.COLON, KtTokens.AS_KEYWORD, KtTokens.AS_SAFE, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.OROR, KtTokens.ANDAND, KtTokens.EQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.ELVIS, KtTokens.EXCLEXCL);

    public static void markDebugAnnotations(@NotNull PsiElement root, final @NotNull BindingContext bindingContext, final @NotNull DebugInfoReporter debugInfoReporter) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        if (debugInfoReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugInfoReporter", "org/jetbrains/kotlin/checkers/DebugInfoUtil", "markDebugAnnotations"));
        }
        final HashMap<KtReferenceExpression, DiagnosticFactory<?>> markedWithErrorElements = Maps.newHashMap();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            DiagnosticFactory<?> factory = diagnostic.getFactory();
            if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(diagnostic.getFactory())) {
                markedWithErrorElements.put((KtReferenceExpression)diagnostic.getPsiElement(), factory);
                continue;
            }
            if (factory == Errors.SUPER_IS_NOT_AN_EXPRESSION || factory == Errors.SUPER_NOT_AVAILABLE) {
                KtSuperExpression superExpression = (KtSuperExpression)diagnostic.getPsiElement();
                markedWithErrorElements.put(superExpression.getInstanceReference(), factory);
                continue;
            }
            if (factory == Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                markedWithErrorElements.put((KtSimpleNameExpression)diagnostic.getPsiElement(), factory);
                continue;
            }
            if (factory != Errors.UNSUPPORTED) continue;
            for (KtReferenceExpression reference : PsiTreeUtil.findChildrenOfType(diagnostic.getPsiElement(), KtReferenceExpression.class)) {
                markedWithErrorElements.put(reference, factory);
            }
        }
        root.acceptChildren(new KtTreeVisitorVoid(){

            @Override
            public void visitForExpression(@NotNull KtForExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitForExpression"));
                }
                KtExpression range = expression.getLoopRange();
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL);
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
                super.visitForExpression(expression);
            }

            @Override
            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                if (destructuringDeclaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringDeclaration", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitDestructuringDeclaration"));
                }
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    this.reportIfDynamicCall(entry, entry, BindingContext.COMPONENT_RESOLVED_CALL);
                }
                super.visitDestructuringDeclaration(destructuringDeclaration);
            }

            @Override
            public void visitProperty(@NotNull KtProperty property) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitProperty"));
                }
                VariableDescriptor descriptor2 = bindingContext.get(BindingContext.VARIABLE, property);
                if (descriptor2 instanceof PropertyDescriptor && property.getDelegate() != null) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
                    this.reportIfDynamicCall(property.getDelegate(), propertyDescriptor.getGetter(), BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL);
                    this.reportIfDynamicCall(property.getDelegate(), propertyDescriptor.getSetter(), BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL);
                    this.reportIfDynamicCall(property.getDelegate(), propertyDescriptor, BindingContext.DELEGATED_PROPERTY_PD_RESOLVED_CALL);
                }
                super.visitProperty(property);
            }

            @Override
            public void visitThisExpression(@NotNull KtThisExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitThisExpression"));
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression, bindingContext);
                if (resolvedCall2 != null) {
                    DebugInfoUtil.reportIfDynamic(expression, resolvedCall2.getResultingDescriptor(), debugInfoReporter);
                }
                super.visitThisExpression(expression);
            }

            @Override
            public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
                Collection<? extends PsiElement> labelTargets;
                Collection<? extends DeclarationDescriptor> declarationDescriptors;
                PsiElement labelTarget;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$1", "visitReferenceExpression"));
                }
                super.visitReferenceExpression(expression);
                if (!BindingContextUtils.isExpressionWithValidReference(expression, bindingContext)) {
                    return;
                }
                IElementType referencedNameElementType = null;
                if (expression instanceof KtSimpleNameExpression) {
                    KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)expression;
                    IElementType elementType = expression.getNode().getElementType();
                    if (elementType == KtNodeTypes.OPERATION_REFERENCE) {
                        referencedNameElementType = nameExpression.getReferencedNameElementType();
                        if (EXCLUDED.contains(referencedNameElementType)) {
                            return;
                        }
                    }
                    if (elementType == KtNodeTypes.LABEL || nameExpression.getReferencedNameElementType() == KtTokens.THIS_KEYWORD) {
                        return;
                    }
                }
                debugInfoReporter.preProcessReference(expression);
                String target = null;
                DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
                if (declarationDescriptor != null) {
                    target = declarationDescriptor.toString();
                    DebugInfoUtil.reportIfDynamic(expression, declarationDescriptor, debugInfoReporter);
                }
                if (target == null && (labelTarget = bindingContext.get(BindingContext.LABEL_TARGET, expression)) != null) {
                    target = labelTarget.getText();
                }
                if (target == null && (declarationDescriptors = bindingContext.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression)) != null) {
                    target = "[" + declarationDescriptors.size() + " descriptors]";
                }
                if (target == null && (labelTargets = bindingContext.get(BindingContext.AMBIGUOUS_LABEL_TARGET, expression)) != null) {
                    target = "[" + labelTargets.size() + " elements]";
                }
                if (MAY_BE_UNRESOLVED.contains(referencedNameElementType)) {
                    return;
                }
                boolean resolved = target != null;
                boolean markedWithError = markedWithErrorElements.containsKey(expression);
                if (expression instanceof KtArrayAccessExpression && markedWithErrorElements.containsKey(((KtArrayAccessExpression)expression).getArrayExpression())) {
                    markedWithError = true;
                }
                KotlinType expressionType = bindingContext.getType(expression);
                DiagnosticFactory factory = (DiagnosticFactory)markedWithErrorElements.get(expression);
                if (declarationDescriptor != null && (ErrorUtils.isError(declarationDescriptor) || ErrorUtils.containsErrorType(expressionType)) && factory != Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                    debugInfoReporter.reportElementWithErrorType(expression);
                }
                if (resolved && markedWithError) {
                    if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(factory)) {
                        debugInfoReporter.reportUnresolvedWithTarget(expression, target);
                    }
                } else if (!resolved && !markedWithError) {
                    debugInfoReporter.reportMissingUnresolved(expression);
                }
            }

            private <E extends KtElement, K, D extends CallableDescriptor> boolean reportIfDynamicCall(E element, K key, WritableSlice<K, ResolvedCall<D>> slice) {
                ResolvedCall<D> resolvedCall2 = bindingContext.get(slice, key);
                if (resolvedCall2 != null) {
                    return DebugInfoUtil.reportIfDynamic(element, resolvedCall2.getResultingDescriptor(), debugInfoReporter);
                }
                return false;
            }
        });
    }

    private static boolean reportIfDynamic(KtElement element, DeclarationDescriptor declarationDescriptor, DebugInfoReporter debugInfoReporter) {
        if (declarationDescriptor != null && DynamicCallsKt.isDynamic(declarationDescriptor)) {
            debugInfoReporter.reportDynamicCall(element, declarationDescriptor);
            return true;
        }
        return false;
    }

    public static abstract class DebugInfoReporter {
        public void preProcessReference(@NotNull KtReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/DebugInfoUtil$DebugInfoReporter", "preProcessReference"));
            }
        }

        public abstract void reportElementWithErrorType(@NotNull KtReferenceExpression var1);

        public abstract void reportMissingUnresolved(@NotNull KtReferenceExpression var1);

        public abstract void reportUnresolvedWithTarget(@NotNull KtReferenceExpression var1, @NotNull String var2);

        public void reportDynamicCall(@NotNull KtElement element, DeclarationDescriptor declarationDescriptor) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/DebugInfoUtil$DebugInfoReporter", "reportDynamicCall"));
            }
        }
    }
}

