/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.cfg.WhenOnClassExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnSealedExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenOnClassExhaustivenessChecker;", "()V", "collectNestedSubclasses", "", "baseDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "currentDescriptor", "subclasses", "", "getMissingCases", "", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "nullable", "", "isApplicable", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
final class WhenOnSealedExhaustivenessChecker
extends WhenOnClassExhaustivenessChecker {
    public static final WhenOnSealedExhaustivenessChecker INSTANCE;

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression, @NotNull BindingContext context, @Nullable ClassDescriptor subjectDescriptor, boolean nullable2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        boolean bl = subjectDescriptor != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "isWhenOnSealedClassExhaustive should be called with not-null subject class descriptor";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassDescriptor classDescriptor = subjectDescriptor;
        if (classDescriptor == null) {
            Intrinsics.throwNpe();
        }
        bl = classDescriptor.getModality() == Modality.SEALED;
        if (_Assertions.ENABLED && !bl) {
            String string = "isWhenOnSealedClassExhaustive should be called with a sealed class descriptor";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        LinkedHashSet memberClassDescriptors = new LinkedHashSet();
        ClassDescriptor classDescriptor2 = subjectDescriptor;
        if (classDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        this.collectNestedSubclasses(classDescriptor2, subjectDescriptor, memberClassDescriptors);
        return CollectionsKt.plus((Collection)this.getMissingClassCases(expression, memberClassDescriptors, context), (Iterable)WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression, context, nullable2));
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkParameterIsNotNull(subjectType, "subjectType");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(subjectType);
        return Intrinsics.areEqual((Object)(classDescriptor != null ? classDescriptor.getModality() : null), (Object)Modality.SEALED);
    }

    private final void collectNestedSubclasses(ClassDescriptor baseDescriptor, ClassDescriptor currentDescriptor, Set<ClassDescriptor> subclasses) {
        for (DeclarationDescriptor descriptor2 : DescriptorUtils.getAllDescriptors(currentDescriptor.getUnsubstitutedInnerClassesScope())) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            if (DescriptorUtils.isDirectSubclass((ClassDescriptor)descriptor2, baseDescriptor)) {
                subclasses.add((ClassDescriptor)descriptor2);
            }
            this.collectNestedSubclasses(baseDescriptor, (ClassDescriptor)descriptor2, subclasses);
        }
    }

    private WhenOnSealedExhaustivenessChecker() {
        INSTANCE = this;
    }

    static {
        new WhenOnSealedExhaustivenessChecker();
    }
}

