/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

public abstract class DataClassMethodGenerator {
    private final KtClassOrObject declaration;
    private final BindingContext bindingContext;
    private final ClassDescriptor classDescriptor;
    private final KotlinBuiltIns builtIns;

    public DataClassMethodGenerator(KtClassOrObject declaration, BindingContext bindingContext) {
        this.declaration = declaration;
        this.bindingContext = bindingContext;
        this.classDescriptor = BindingContextUtils.getNotNull(bindingContext, BindingContext.CLASS, declaration);
        this.builtIns = DescriptorUtilsKt.getBuiltIns(this.classDescriptor);
    }

    public void generate() {
        this.generateComponentFunctionsForDataClasses();
        this.generateCopyFunctionForDataClasses(this.getPrimaryConstructorParameters());
        List<PropertyDescriptor> properties2 = this.getDataProperties();
        if (!properties2.isEmpty()) {
            this.generateDataClassToStringIfNeeded(properties2);
            this.generateDataClassHashCodeIfNeeded(properties2);
            this.generateDataClassEqualsIfNeeded(properties2);
        }
    }

    protected abstract void generateComponentFunction(@NotNull FunctionDescriptor var1, @NotNull ValueParameterDescriptor var2);

    protected abstract void generateCopyFunction(@NotNull FunctionDescriptor var1, @NotNull List<KtParameter> var2);

    protected abstract void generateToStringMethod(@NotNull FunctionDescriptor var1, @NotNull List<PropertyDescriptor> var2);

    protected abstract void generateHashCodeMethod(@NotNull FunctionDescriptor var1, @NotNull List<PropertyDescriptor> var2);

    protected abstract void generateEqualsMethod(@NotNull FunctionDescriptor var1, @NotNull List<PropertyDescriptor> var2);

    @NotNull
    protected ClassDescriptor getClassDescriptor() {
        ClassDescriptor classDescriptor = this.classDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    private void generateComponentFunctionsForDataClasses() {
        ConstructorDescriptor constructor = this.classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (constructor == null) {
            return;
        }
        for (ValueParameterDescriptor parameter : constructor.getValueParameters()) {
            FunctionDescriptor function = this.bindingContext.get(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter);
            if (function == null) continue;
            this.generateComponentFunction(function, parameter);
        }
    }

    private void generateCopyFunctionForDataClasses(List<KtParameter> constructorParameters) {
        FunctionDescriptor copyFunction = this.bindingContext.get(BindingContext.DATA_CLASS_COPY_FUNCTION, this.classDescriptor);
        if (copyFunction != null) {
            this.generateCopyFunction(copyFunction, constructorParameters);
        }
    }

    private void generateDataClassToStringIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "generateDataClassToStringIfNeeded"));
        }
        FunctionDescriptor function = this.getDeclaredMember("toString", this.builtIns.getString(), new ClassDescriptor[0]);
        if (function != null && this.isTrivial(function)) {
            this.generateToStringMethod(function, properties2);
        }
    }

    private void generateDataClassHashCodeIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "generateDataClassHashCodeIfNeeded"));
        }
        FunctionDescriptor function = this.getDeclaredMember("hashCode", this.builtIns.getInt(), new ClassDescriptor[0]);
        if (function != null && this.isTrivial(function)) {
            this.generateHashCodeMethod(function, properties2);
        }
    }

    private void generateDataClassEqualsIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "generateDataClassEqualsIfNeeded"));
        }
        FunctionDescriptor function = this.getDeclaredMember("equals", this.builtIns.getBoolean(), this.builtIns.getAny());
        if (function != null && this.isTrivial(function)) {
            this.generateEqualsMethod(function, properties2);
        }
    }

    private List<PropertyDescriptor> getDataProperties() {
        ArrayList<PropertyDescriptor> result2 = Lists.newArrayList();
        for (KtParameter parameter : this.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVar()) continue;
            result2.add(this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter));
        }
        return result2;
    }

    @NotNull
    private List<KtParameter> getPrimaryConstructorParameters() {
        if (this.declaration instanceof KtClass) {
            List<KtParameter> list2 = this.declaration.getPrimaryConstructorParameters();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "getPrimaryConstructorParameters"));
            }
            return list2;
        }
        List<KtParameter> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "getPrimaryConstructorParameters"));
        }
        return list3;
    }

    @Nullable
    private FunctionDescriptor getDeclaredMember(@NotNull String name, @NotNull ClassDescriptor returnedClassifier, ClassDescriptor ... valueParameterClassifiers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "getDeclaredMember"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "getDeclaredMember"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "getDeclaredMember"));
        }
        return CodegenUtil.getDeclaredFunctionByRawSignature(this.classDescriptor, Name.identifier(name), returnedClassifier, valueParameterClassifiers);
    }

    private boolean isTrivial(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/backend/common/DataClassMethodGenerator", "isTrivial"));
        }
        if (function.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return false;
        }
        for (CallableDescriptor callableDescriptor : OverrideResolver.getOverriddenDeclarations(function)) {
            if (!(callableDescriptor instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)callableDescriptor).getKind() != CallableMemberDescriptor.Kind.DECLARATION || callableDescriptor.getContainingDeclaration().equals(this.builtIns.getAny())) continue;
            return false;
        }
        return true;
    }
}

