/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.org.jdom.Element;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){

        @Override
        public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializer$1", "accepts"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer$1", "accepts"));
            }
            return true;
        }
    };

    private XmlSerializer() {
    }

    public static Element serialize(@NotNull Object object) throws XmlSerializationException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializer", "serialize"));
        }
        return XmlSerializer.serialize(object, TRUE_FILTER);
    }

    @NotNull
    public static Element serialize(@NotNull Object object, @Nullable SerializationFilter filter2) throws XmlSerializationException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializer", "serialize"));
        }
        Element element = XmlSerializerImpl.serialize(object, filter2 == null ? TRUE_FILTER : filter2);
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializer", "serialize"));
        }
        return element;
    }

    @Nullable
    public static <T> T deserialize(@NotNull Element element, @NotNull Class<T> aClass2) throws XmlSerializationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        try {
            return (T)XmlSerializerImpl.getBinding(aClass2).deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass2.getName(), e);
        }
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        XmlSerializer.deserializeInto(bean, element, null);
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        try {
            ((BeanBinding)XmlSerializerImpl.getBinding(bean.getClass())).deserializeInto(bean, element, accessorNameTracker);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

