/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.gnu.trove.THashSet;
import org.jetbrains.kotlin.relocated.gnu.trove.TObjectHashingStrategy;

public class WeakInterner<T> {
    private final ConcurrentMap<T, T> myMap;

    public WeakInterner() {
        this.myMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
    }

    public WeakInterner(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/WeakInterner", "<init>"));
        }
        this.myMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap(strategy);
    }

    @NotNull
    public T intern(@NotNull T name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/containers/WeakInterner", "intern"));
        }
        T t = ConcurrencyUtil.cacheOrGet(this.myMap, name, name);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakInterner", "intern"));
        }
        return t;
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public Set<T> getValues() {
        THashSet tHashSet = ContainerUtil.newTroveSet(this.myMap.values());
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakInterner", "getValues"));
        }
        return tHashSet;
    }
}

